/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class IpAddressValidator {
    private static final String IPV4_BASIC_PATTERN_STRING = "(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern IP_V4_AND_V6_PATTERN = Pattern.compile("[0-9\\.\\:a-fA-F]+");

    public boolean isValid(String ipString) {
        if (StringUtils.isEmpty((CharSequence)ipString) || ipString.length() < 7) {
            return false;
        }
        if (!IP_V4_AND_V6_PATTERN.matcher(ipString).matches()) {
            return false;
        }
        try {
            InetAddress.getByName(ipString);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public boolean isValidIPV4(String ipV4String) {
        if (StringUtils.isEmpty((CharSequence)ipV4String) || ipV4String.length() < 7 || ipV4String.length() > 15) {
            return false;
        }
        return IPV4_PATTERN.matcher(ipV4String).matches();
    }
}

