/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeTagsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.TagDescription;
import pl.codewise.commons.aws.AwsEc2Instance;
import pl.codewise.commons.aws.InstanceNameProvider;

public class EC2InstanceNameProvider
implements InstanceNameProvider {
    static final String RESOURCE_ID_TAG = "resource-id";
    static final String RESOURCE_NAME_TAG = "name";
    private final AmazonEC2 amazonEC2;
    private final AwsEc2Instance awsEc2Instance;

    public EC2InstanceNameProvider(AmazonEC2 amazonEC2, AwsEc2Instance awsEc2Instance) {
        this.amazonEC2 = amazonEC2;
        this.awsEc2Instance = awsEc2Instance;
    }

    @Override
    public String getInstanceName() {
        return this.amazonEC2.describeTags(new DescribeTagsRequest().withFilters(new Filter[]{new Filter().withName(RESOURCE_ID_TAG).withValues(new String[]{this.awsEc2Instance.getInstanceId()})})).getTags().stream().filter(tag -> RESOURCE_NAME_TAG.equalsIgnoreCase(tag.getKey())).map(TagDescription::getValue).findFirst().orElse(null);
    }
}

