/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws;

import pl.codewise.commons.aws.AwsEc2Instance;
import pl.codewise.commons.aws.IpAddressValidator;
import pl.codewise.commons.aws.IpProvider;
import pl.codewise.commons.aws.IpResolutionException;

public class EC2InstanceIpProvider
implements IpProvider {
    private static final IpAddressValidator IP_ADDRESS_VALIDATOR = new IpAddressValidator();
    private final AwsEc2Instance awsEc2Instance;

    public EC2InstanceIpProvider(AwsEc2Instance awsEc2Instance) {
        this.awsEc2Instance = awsEc2Instance;
    }

    @Override
    public String getIp() throws IpResolutionException {
        String instanceIp = this.awsEc2Instance.getInstanceIp();
        if (IP_ADDRESS_VALIDATOR.isValid(instanceIp)) {
            return instanceIp;
        }
        throw new IpResolutionException("Amazon instance resolution failed. Ip resolved to: " + instanceIp);
    }
}

