/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.s3.AmazonS3;
import java.util.concurrent.ConcurrentHashMap;
import pl.codewise.commons.aws.cqrs.factories.AmazonClientBuilders;
import pl.codewise.commons.aws.cqrs.factories.AssumeRoleParameters;
import pl.codewise.commons.aws.cqrs.factories.internal.Builder;

public class AwsClientsCache {
    private final ConcurrentHashMap<String, AmazonEC2> amazonEc2Cache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AmazonAutoScaling> amazonAutoScalingCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AWSLambda> awsLambdaCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AmazonElasticLoadBalancing> amazonElasticLoadBalancingCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing> applicationLoadBalancingCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AmazonCloudWatch> amazonCloudWatchCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AmazonRoute53> amazonRoute53Cache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AmazonRoute53Domains> amazonRoute53DomainsCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AmazonIdentityManagement> amazonIdentityManagementCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AmazonS3> amazonS3Cache = new ConcurrentHashMap();
    private final AmazonClientBuilders amazonClientBuilders;

    public AwsClientsCache(AmazonClientBuilders amazonClientBuilders) {
        this.amazonClientBuilders = amazonClientBuilders;
    }

    public static <T> T awsClient(AssumeRoleParameters parameters, Builder<T> builder) {
        return builder.withAssumeRoleParameters(parameters).get();
    }

    public static <T> T awsClient(String region, Builder<T> builder) {
        return builder.withRegion(region).get();
    }

    public static <T> T awsClient(String region, AssumeRoleParameters parameters, Builder<T> builder) {
        return builder.withRegion(region).withAssumeRoleParameters(parameters).get();
    }

    public AmazonS3 newAmazonS3() {
        return this.amazonS3Cache.computeIfAbsent("DEFAULT_S3_CLIENT", k -> this.awsClient(this.amazonClientBuilders.s3()));
    }

    public AmazonS3 newAmazonS3(AssumeRoleParameters parameters) {
        return this.amazonS3Cache.computeIfAbsent(this.cacheKey("S3_CLIENT", parameters), k -> AwsClientsCache.awsClient(parameters, this.amazonClientBuilders.s3()));
    }

    public AmazonIdentityManagement newAmazonIdentityManagement() {
        return this.amazonIdentityManagementCache.computeIfAbsent("DEFAULT_IAM_CLIENT", k -> this.awsClient(this.amazonClientBuilders.iam()));
    }

    public AmazonIdentityManagement newAmazonIdentityManagement(AssumeRoleParameters parameters) {
        return this.amazonIdentityManagementCache.computeIfAbsent(this.cacheKey("IAM_CLIENT", parameters), k -> AwsClientsCache.awsClient(parameters, this.amazonClientBuilders.iam()));
    }

    public AmazonRoute53 newAmazonRoute53() {
        return this.amazonRoute53Cache.computeIfAbsent("DEFAULT_ROUTE53_CLIENT", k -> this.awsClient(this.amazonClientBuilders.route53()));
    }

    public AmazonRoute53 newAmazonRoute53(AssumeRoleParameters parameters) {
        String cacheKey = this.cacheKey("ROUTE53_CLIENT", parameters);
        return this.amazonRoute53Cache.computeIfAbsent(cacheKey, k -> AwsClientsCache.awsClient(parameters, this.amazonClientBuilders.route53()));
    }

    public AmazonRoute53Domains newAmazonRoute53Domains(AssumeRoleParameters parameters) {
        String cacheKey = this.cacheKey("ROUTE53DOMAINS_CLIENT", parameters);
        return this.amazonRoute53DomainsCache.computeIfAbsent(cacheKey, k -> AwsClientsCache.awsClient(parameters, this.amazonClientBuilders.route53Domains()));
    }

    public AmazonRoute53Domains newAmazonRoute53Domains() {
        return this.amazonRoute53DomainsCache.computeIfAbsent("DEFAULT_ROUTE53DOMAINS_CLIENT", k -> this.awsClient(this.amazonClientBuilders.route53Domains()));
    }

    public AmazonEC2 newAmazonEC2(String region) {
        return this.amazonEc2Cache.computeIfAbsent(region, k -> AwsClientsCache.awsClient(region, this.amazonClientBuilders.ec2()));
    }

    public AmazonEC2 newAmazonEC2(String region, AssumeRoleParameters parameters) {
        return this.amazonEc2Cache.computeIfAbsent(this.cacheKey(region, parameters), k -> AwsClientsCache.awsClient(region, parameters, this.amazonClientBuilders.ec2()));
    }

    public AmazonAutoScaling newAmazonAutoScaling(String region) {
        return this.amazonAutoScalingCache.computeIfAbsent(region, k -> AwsClientsCache.awsClient(region, this.amazonClientBuilders.autoScaling()));
    }

    public AmazonAutoScaling newAmazonAutoScaling(String region, AssumeRoleParameters parameters) {
        return this.amazonAutoScalingCache.computeIfAbsent(this.cacheKey(region, parameters), k -> AwsClientsCache.awsClient(region, parameters, this.amazonClientBuilders.autoScaling()));
    }

    public AWSLambda newAwsLambda(String region) {
        return this.awsLambdaCache.computeIfAbsent(region, k -> AwsClientsCache.awsClient(region, this.amazonClientBuilders.awsLambda()));
    }

    public AWSLambda newAwsLambda(String region, AssumeRoleParameters parameters) {
        return this.awsLambdaCache.computeIfAbsent(this.cacheKey(region, parameters), k -> AwsClientsCache.awsClient(region, parameters, this.amazonClientBuilders.awsLambda()));
    }

    public AmazonElasticLoadBalancing newAmazonElasticLoadBalancing(String region) {
        return this.amazonElasticLoadBalancingCache.computeIfAbsent(region, k -> AwsClientsCache.awsClient(region, this.amazonClientBuilders.amazonElasticLoadBalancing()));
    }

    public AmazonElasticLoadBalancing newAmazonElasticLoadBalancing(String region, AssumeRoleParameters parameters) {
        return this.amazonElasticLoadBalancingCache.computeIfAbsent(this.cacheKey(region, parameters), k -> AwsClientsCache.awsClient(region, parameters, this.amazonClientBuilders.amazonElasticLoadBalancing()));
    }

    public com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing newApplicationLoadBalancing(String region) {
        return this.applicationLoadBalancingCache.computeIfAbsent(region, k -> AwsClientsCache.awsClient(region, this.amazonClientBuilders.applicationLoadBalancing()));
    }

    public com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing newApplicationLoadBalancing(String region, AssumeRoleParameters parameters) {
        return this.applicationLoadBalancingCache.computeIfAbsent(this.cacheKey(region, parameters), k -> AwsClientsCache.awsClient(region, parameters, this.amazonClientBuilders.applicationLoadBalancing()));
    }

    public AmazonCloudWatch newAmazonCloudWatch(String region) {
        return this.amazonCloudWatchCache.computeIfAbsent(region, k -> AwsClientsCache.awsClient(region, this.amazonClientBuilders.amazonCloudWatch()));
    }

    public AmazonCloudWatch newAmazonCloudWatch(String region, AssumeRoleParameters parameters) {
        return this.amazonCloudWatchCache.computeIfAbsent(this.cacheKey(region, parameters), k -> AwsClientsCache.awsClient(region, parameters, this.amazonClientBuilders.amazonCloudWatch()));
    }

    private <T> T awsClient(Builder<T> builder) {
        return builder.get();
    }

    private String cacheKey(String prefix, AssumeRoleParameters parameters) {
        return prefix + "-" + parameters.getRoleArn();
    }
}

