/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.utils;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import pl.codewise.commons.aws.cqrs.utils.BatchQuery;

@RunWith(value=MockitoJUnitRunner.class)
public class BatchQueryTest {
    @Mock
    private Req req;
    @Mock
    private Res res;
    @Mock
    private Collaborator collaborator;
    private BatchQuery<Req, Res, Integer> batchQuery;

    @Before
    public void setUp() {
        this.batchQuery = new BatchQuery.Builder().requesting((Object)this.req).settingNewToken((token, request) -> request.setNextToken((String)token)).executingRequest(this.collaborator::accept).havingResultIn(Res::getResults).havingNextTokenIn(Res::getNextToken).build();
    }

    @Test
    public void shouldPerformInSingleBatch() {
        BDDMockito.given((Object)this.collaborator.accept(this.req)).willReturn((Object)this.res);
        BDDMockito.given(this.res.getResults()).willReturn(Arrays.asList(1, 2, 3));
        BDDMockito.given((Object)this.res.getNextToken()).willReturn(null);
        List result = this.batchQuery.execute();
        Assertions.assertThat((List)result).containsExactly((Object[])new Integer[]{1, 2, 3});
    }

    @Test
    public void shouldPerformInMultipleBatches() {
        BDDMockito.given((Object)this.collaborator.accept(this.req)).willReturn((Object)this.res);
        BDDMockito.given(this.res.getResults()).willReturn(Arrays.asList(1, 2, 3)).willReturn(Arrays.asList(4, 5, 6)).willReturn(Arrays.asList(7, 8, 9));
        BDDMockito.given((Object)this.res.getNextToken()).willReturn((Object)"first-token").willReturn((Object)"second-token").willReturn(null);
        List result = this.batchQuery.execute();
        Assertions.assertThat((List)result).containsExactly((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    private static abstract class Collaborator {
        private Collaborator() {
        }

        abstract Res accept(Req var1);
    }

    private static abstract class Res {
        private Res() {
        }

        abstract List<Integer> getResults();

        abstract String getNextToken();
    }

    private static abstract class Req {
        private Req() {
        }

        abstract void setNextToken(String var1);
    }
}

