/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.utils;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import pl.codewise.commons.aws.cqrs.utils.Awaitilities;

@RunWith(value=MockitoJUnitRunner.class)
public class AwaitilitiesTest {
    @Mock
    private Queue<String> source;
    private Awaitilities awaitilities;

    @Before
    public void setUp() {
        this.awaitilities = new Awaitilities();
    }

    @Test
    public void shouldThrowGenericRuntimeExceptionWithDefaultMessage() {
        Mockito.when((Object)this.source.poll()).thenReturn(null).thenReturn(null).thenReturn(null).thenReturn(null);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(this::await).withMessage("Default message");
    }

    @Test
    public void shouldRethrowLastUncheckedExceptionThatOccurredWhileRetrying() {
        Mockito.when((Object)this.source.poll()).thenReturn(null).thenThrow(new Throwable[]{new IllegalStateException("Illegal")}).thenThrow(new Throwable[]{new UnsupportedOperationException("Unsupported")}).thenReturn(null);
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(this::await).withMessage("Unsupported");
    }

    @Test
    public void shouldReturnCorrectValueEventThoughSomeExceptionOccurred() {
        Mockito.when((Object)this.source.poll()).thenReturn(null).thenThrow(new Throwable[]{new NoSuchElementException("NoSuchElement")}).thenReturn((Object)"Finally got it!");
        String s = this.await();
        Assertions.assertThat((String)s).isEqualTo((Object)"Finally got it!");
    }

    @Test
    public void shouldReturnLastValueIfConditionHasNotMet() {
        Mockito.when((Object)this.source.poll()).thenReturn((Object)"PENDING").thenThrow(new Throwable[]{new RuntimeException("Not Found")}).thenReturn((Object)"PENDING").thenReturn((Object)"PENDING").thenReturn((Object)"PENDING").thenReturn((Object)"PENDING");
        String value = (String)this.awaitilities.awaitForValueOrReturnLastValue(1000, 100, () -> this.source.poll(), (Matcher)Matchers.both((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)"PENDING"))).and(IsNot.not((Matcher)Matchers.isEmptyOrNullString())), "Default message");
        Assertions.assertThat((String)value).isEqualTo((Object)"PENDING");
    }

    @Test
    public void shouldReturnValueIfConditionHasMet() {
        Mockito.when((Object)this.source.poll()).thenReturn((Object)"PENDING").thenThrow(new Throwable[]{new RuntimeException("Not Found")}).thenReturn((Object)"PENDING").thenReturn((Object)"AVAILABLE").thenReturn((Object)"PENDING").thenReturn((Object)"PENDING");
        String value = (String)this.awaitilities.awaitForValueOrReturnLastValue(1000, 100, () -> this.source.poll(), (Matcher)Matchers.both((Matcher)IsNot.not((Matcher)IsEqual.equalTo((Object)"PENDING"))).and(IsNot.not((Matcher)Matchers.isEmptyOrNullString())), "Default message");
        Assertions.assertThat((String)value).isEqualTo((Object)"AVAILABLE");
    }

    @Test
    public void shouldUseProvidedMessageWhenTimedOut() {
        ArrayDeque<Boolean> source = new ArrayDeque<Boolean>(Arrays.asList(false, false, false, false, false));
        Throwable t = Assertions.catchThrowable(() -> this.awaitilities.awaitTillActionSucceed(400L, 100L, 0L, "XYZ", source::poll));
        Assertions.assertThat((Throwable)t).hasMessage("Wait for XYZ timed out after 400ms");
    }

    private String await() {
        return (String)this.awaitilities.awaitForValue(400, 100, () -> this.source.poll(), "Default message");
    }
}

