/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.util.Collection;
import java.util.List;
import org.mockito.Mockito;

public class S3TestUtils {
    public static void fillInS3Bucket(AmazonS3 amazonS3, String bucket, String prefix, Collection<String> keys) {
        ObjectListing listing = S3TestUtils.prepareObjectListingWithKeys(bucket, keys);
        Mockito.when((Object)amazonS3.listObjects(bucket, prefix)).thenReturn((Object)listing);
    }

    public static ObjectListing prepareObjectListingWithKeys(String bucket, Collection<String> keys) {
        ObjectListing listing = new ObjectListing();
        List objectSummaries = listing.getObjectSummaries();
        keys.forEach(key -> objectSummaries.add(S3TestUtils.objectSummary(bucket, key)));
        return listing;
    }

    private static S3ObjectSummary objectSummary(String bucket, String key) {
        S3ObjectSummary s3ObjectSummary = new S3ObjectSummary();
        s3ObjectSummary.setBucketName(bucket);
        s3ObjectSummary.setKey(key);
        return s3ObjectSummary;
    }
}

