/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Files;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import pl.codewise.commons.aws.cqrs.discovery.S3Discovery;
import pl.codewise.commons.aws.cqrs.operations.s3.PutResult;
import pl.codewise.commons.aws.cqrs.operations.s3.S3Operations;
import pl.codewise.commons.aws.cqrs.operations.s3.S3TestUtils;
import pl.codewise.commons.aws.cqrs.utils.FileSystem;

@RunWith(value=MockitoJUnitRunner.class)
public class S3OperationsTest {
    @Mock
    private AmazonS3 amazonS3;
    private final FileSystem fileSystem = new FileSystem();
    private S3Operations s3Operations;

    @Before
    public void before() {
        this.s3Operations = this.newS3Operations();
    }

    @Test
    public void shouldPutTextFile() {
        PutResult putResult = this.s3Operations.putText((List)ImmutableList.of((Object)"bucket-us-east-1"), "key", "text");
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).isNotEmpty();
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(PutObjectRequest.class);
        ((AmazonS3)Mockito.verify((Object)this.amazonS3)).putObject((PutObjectRequest)argumentCaptor.capture());
        PutObjectRequest request = (PutObjectRequest)argumentCaptor.getValue();
        Assertions.assertThat((String)request.getKey()).isEqualTo((Object)"key");
    }

    @Test
    public void shouldPutTextToAllBuckets() {
        PutResult putResult = this.s3Operations.putText((List)ImmutableList.of((Object)"bucket-us-east-1", (Object)"bucket-eu-central-1"), "key", "text");
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).isNotEmpty();
        Assertions.assertThat((List)putResult.getFailedBuckets()).isEmpty();
    }

    @Test
    public void shouldReturnTrueWhenManagedToPutTextToAtLeastOneBucket() {
        Mockito.when((Object)this.amazonS3.putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class))).thenReturn((Object)new PutObjectResult()).thenThrow(new Throwable[]{new RuntimeException("text exception")});
        PutResult putResult = this.s3Operations.putText((List)ImmutableList.of((Object)"bucket-us-east-1", (Object)"bucket-eu-central-1"), "key", "text");
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).isNotEmpty();
        Assertions.assertThat((List)putResult.getFailedBuckets()).isNotEmpty();
    }

    @Test
    public void shouldReturnFalseWhenCouldNotPutTextToAnyBucket() {
        Mockito.when((Object)this.amazonS3.putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class))).thenThrow(new Throwable[]{new RuntimeException("text exception")});
        PutResult putResult = this.s3Operations.putText((List)ImmutableList.of((Object)"bucket-us-east-1", (Object)"bucket-eu-central-1"), "key", "text");
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).isEmpty();
        Assertions.assertThat((List)putResult.getFailedBuckets()).isNotEmpty();
    }

    @Test
    public void shouldPutFile() {
        File temporaryFile = Files.newTemporaryFile();
        PutResult putResult = this.s3Operations.putFile((List)ImmutableList.of((Object)"bucket-us-east-1"), "key", temporaryFile);
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).isNotEmpty();
        Assertions.assertThat((List)putResult.getFailedBuckets()).isEmpty();
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(PutObjectRequest.class);
        ((AmazonS3)Mockito.verify((Object)this.amazonS3)).putObject((PutObjectRequest)argumentCaptor.capture());
        PutObjectRequest request = (PutObjectRequest)argumentCaptor.getValue();
        File file = request.getFile();
        Assertions.assertThat((File)file.getAbsoluteFile()).isEqualTo((Object)temporaryFile);
        Assertions.assertThat((String)request.getKey()).isEqualTo((Object)"key");
    }

    @Test
    public void shouldPutFileToAllBuckets() {
        File file = Files.newTemporaryFile();
        PutResult putResult = this.s3Operations.putFile((List)ImmutableList.of((Object)"bucket-us-east-1", (Object)"bucket-eu-central-1"), "key", file);
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).isNotEmpty();
        Assertions.assertThat((List)putResult.getFailedBuckets()).isEmpty();
    }

    @Test
    public void shouldReturnTrueWhenManagedToPutFileToAtLeastOneBucket() {
        Mockito.when((Object)this.amazonS3.putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class))).thenThrow(new Throwable[]{new RuntimeException("text exception")}).thenReturn((Object)new PutObjectResult());
        PutResult putResult = this.s3Operations.putFile((List)ImmutableList.of((Object)"bucket-us-east-1", (Object)"bucket-eu-central-1"), "key", new File("/tmp/a"));
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).isNotEmpty();
        Assertions.assertThat((List)putResult.getFailedBuckets()).isNotEmpty();
    }

    @Test
    public void shouldReturnFalseWhenCouldNotPutFileToAnyBucket() {
        Mockito.when((Object)this.amazonS3.putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class))).thenThrow(new Throwable[]{new RuntimeException("text exception")});
        PutResult putResult = this.s3Operations.putFile((List)ImmutableList.of((Object)"bucket-us-east-1", (Object)"bucket-eu-central-1"), "key", new File("/tmp/a"));
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).isEmpty();
        Assertions.assertThat((List)putResult.getFailedBuckets()).isNotEmpty();
    }

    @Test
    public void shouldSuccessfullyRetryPutFileOperation() {
        File file = Files.newTemporaryFile();
        Mockito.when((Object)this.amazonS3.putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class))).thenThrow(new Throwable[]{new RuntimeException("text exception")}).thenThrow(new Throwable[]{new RuntimeException("text exception")}).thenReturn((Object)new PutObjectResult());
        S3Operations s3Operations = this.newS3OperationsWithRetryCount(3);
        PutResult putResult = s3Operations.putFile((List)ImmutableList.of((Object)"bucket-us-east-1"), "key", file);
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).isNotEmpty();
        Assertions.assertThat((List)putResult.getFailedBuckets()).isEmpty();
    }

    @Test
    public void shouldFailToRetryPutFileOperation() {
        File file = Files.newTemporaryFile();
        Mockito.when((Object)this.amazonS3.putObject((PutObjectRequest)ArgumentMatchers.any(PutObjectRequest.class))).thenThrow(new Throwable[]{new RuntimeException("text exception")}).thenThrow(new Throwable[]{new RuntimeException("text exception")}).thenThrow(new Throwable[]{new RuntimeException("text exception")}).thenReturn((Object)new PutObjectResult());
        S3Operations s3Operations = this.newS3OperationsWithRetryCount(3);
        PutResult putResult = s3Operations.putFile((List)ImmutableList.of((Object)"bucket-us-east-1"), "key", file);
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).isEmpty();
        Assertions.assertThat((List)putResult.getFailedBuckets()).isNotEmpty();
    }

    @Test
    public void shouldNotDeleteObject() {
        String bucket = "test-bucket";
        String key = "test-key";
        ((AmazonS3)Mockito.doThrow((Throwable[])new Throwable[]{new AmazonClientException("UnableToDelete")}).when((Object)this.amazonS3)).deleteObject(bucket, key);
        this.s3Operations = this.newS3Operations();
        Throwable throwable = Assertions.catchThrowable(() -> this.s3Operations.deleteObject(bucket, key));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonClientException.class)).hasMessageContaining("UnableToDelete");
    }

    @Test
    public void shouldDeleteObject() {
        String bucket = "test-bucket";
        String key = "test-key";
        this.s3Operations = this.newS3Operations();
        this.s3Operations.deleteObject(bucket, key);
        ((AmazonS3)Mockito.verify((Object)this.amazonS3)).deleteObject(bucket, key);
    }

    @Test
    public void shouldDeleteRecursively() {
        String bucket = "test-bucket";
        String prefix = "test-prefix";
        List<String> keys = Arrays.asList("test-prefix/abc/def", "test-prefix/abc/ghi", "test-prefix/ijk");
        S3TestUtils.fillInS3Bucket(this.amazonS3, bucket, prefix, keys);
        S3Operations s3Operations = this.newS3Operations();
        s3Operations.deleteRecursively(bucket, prefix);
        ArgumentCaptor captor = ArgumentCaptor.forClass(DeleteObjectsRequest.class);
        ((AmazonS3)Mockito.verify((Object)this.amazonS3)).deleteObjects((DeleteObjectsRequest)captor.capture());
        DeleteObjectsRequest request = (DeleteObjectsRequest)captor.getValue();
        Assertions.assertThat((String)request.getBucketName()).isEqualTo((Object)bucket);
        Assertions.assertThat((List)request.getKeys()).extracting("key").containsAll(keys);
    }

    private S3Operations newS3Operations() {
        return this.newS3OperationsWithRetryCount(1);
    }

    private S3Operations newS3OperationsWithRetryCount(int retryCount) {
        S3Discovery s3Discovery = new S3Discovery(this.amazonS3);
        return new S3Operations(this.amazonS3, s3Discovery, this.fileSystem, retryCount, retryCount);
    }
}

