/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations.s3;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import pl.codewise.commons.aws.cqrs.operations.s3.PutResult;

public class PutResultTest {
    @Test
    public void shouldCollectSuccess() {
        PutResult putResult = new PutResult();
        putResult.collect(true, "bucket-x", null);
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).contains((Object[])new String[]{"bucket-x"});
        Assertions.assertThat((List)putResult.getFailedBuckets()).isEmpty();
        Assertions.assertThat((List)putResult.getErrorMessages()).isEmpty();
    }

    @Test
    public void shouldCollectFailure() {
        PutResult putResult = new PutResult();
        putResult.collect(false, "bucket-y", "Some error message");
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).isEmpty();
        Assertions.assertThat((List)putResult.getFailedBuckets()).contains((Object[])new String[]{"bucket-y"});
        Assertions.assertThat((List)putResult.getErrorMessages()).containsOnly((Object[])new String[]{"Some error message"});
    }

    @Test
    public void shouldHandleMultipleResults() {
        PutResult putResult = new PutResult();
        putResult.collect(true, "first-bucket", null);
        putResult.collect(true, "second-bucket", null);
        putResult.collect(false, "third-bucket", "Failure");
        putResult.collect(true, "fourth-bucket", null);
        putResult.collect(false, "fifth-bucket", "Warning");
        Assertions.assertThat((List)putResult.getSuccessfulBuckets()).containsExactly((Object[])new String[]{"first-bucket", "second-bucket", "fourth-bucket"});
        Assertions.assertThat((List)putResult.getFailedBuckets()).containsExactly((Object[])new String[]{"third-bucket", "fifth-bucket"});
        Assertions.assertThat((List)putResult.getErrorMessages()).containsExactly((Object[])new String[]{"Failure", "Warning"});
    }
}

