/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AmazonEC2Exception;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressResult;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupResult;
import com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest;
import com.amazonaws.services.ec2.model.DeleteSecurityGroupResult;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.IpRange;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.OngoingStubbing;
import pl.codewise.commons.aws.cqrs.model.ec2.sg.AwsSecurityGroup;
import pl.codewise.commons.aws.cqrs.model.ec2.sg.GroupInboundRule;
import pl.codewise.commons.aws.cqrs.model.ec2.sg.InboundRule;
import pl.codewise.commons.aws.cqrs.model.ec2.sg.IpInboundRule;
import pl.codewise.commons.aws.cqrs.operations.ec2.SecurityGroupOperations;

@RunWith(value=MockitoJUnitRunner.class)
public class SecurityGroupOperationsTest {
    private SecurityGroupOperations securityGroupOperations;
    @Mock
    private AmazonEC2 amazonEC2;
    private String protocol = "tcp";
    private final String groupName = "test-sg";
    private final String groupId = "sg-9876543";
    private final String sourceGroupId = "sg-8765432";
    private final String sourceIpAddress = "123.123.123.123/32";
    private final int fromPort = 1234;
    private final int toPort = 4321;
    private final InboundRule inboundRuleForIpAddress = new IpInboundRule(this.protocol, "sg-9876543", 1234, 4321, "123.123.123.123/32");
    private final InboundRule inboundRuleForGroup = new GroupInboundRule(this.protocol, "sg-9876543", 1234, 4321, "sg-8765432");
    private final String vpc = "vpc-1234567";

    @Before
    public void setUp() {
        this.securityGroupOperations = new SecurityGroupOperations(this.amazonEC2);
    }

    @Test
    public void shouldNotCreateSecurityGroup() {
        this.givenUnableToCreateSecurityGroup((Exception)new AmazonEC2Exception("UnableToCreate"));
        Throwable throwable = Assertions.catchThrowable(() -> this.securityGroupOperations.createSecurityGroup("test-sg", "vpc-1234567"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonEC2Exception.class)).hasMessageContaining("UnableToCreate");
    }

    @Test
    public void shouldCreateSecurityGroup() {
        this.givenCreatedGroupWithId("sg-9876543");
        AwsSecurityGroup newGroup = this.securityGroupOperations.createSecurityGroup("test-sg", "vpc-1234567");
        Assertions.assertThat((Object)newGroup).isEqualTo((Object)new AwsSecurityGroup("sg-9876543"));
    }

    @Test
    public void shouldNotDeleteSecurityGroup() {
        this.whenDeleteSecurityGroupRequested("sg-9876543").thenThrow(new Throwable[]{new AmazonEC2Exception("UnableToDeleteSecurityGroup")});
        Throwable throwable = Assertions.catchThrowable(() -> this.securityGroupOperations.deleteSecurityGroup("sg-9876543"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonEC2Exception.class)).hasMessageContaining("UnableToDeleteSecurityGroup");
    }

    @Test
    public void shouldDeleteSecurityGroup() {
        this.whenDeleteSecurityGroupRequested("sg-9876543").thenReturn((Object)this.someDeleteSecurityGroupResult());
        this.securityGroupOperations.deleteSecurityGroup("sg-9876543");
        ((AmazonEC2)Mockito.verify((Object)this.amazonEC2)).deleteSecurityGroup(new DeleteSecurityGroupRequest().withGroupId("sg-9876543"));
    }

    @Test
    public void shouldNotAddRuleForGroup() {
        this.whenAddIpPermissionForGroupRequested().thenThrow(new Throwable[]{new AmazonEC2Exception("UnableToAddRule")});
        Throwable throwable = Assertions.catchThrowable(() -> this.securityGroupOperations.addInboundRule(this.inboundRuleForGroup));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonEC2Exception.class)).hasMessageContaining("UnableToAddRule");
    }

    @Test
    public void shouldAddRuleForGroup() {
        this.securityGroupOperations.addInboundRule(this.inboundRuleForGroup);
        ((AmazonEC2)Mockito.verify((Object)this.amazonEC2)).authorizeSecurityGroupIngress(new AuthorizeSecurityGroupIngressRequest().withGroupId("sg-9876543").withIpPermissions(new IpPermission[]{this.ipPermissionsForGroup()}));
    }

    @Test
    public void shouldNotAddRuleForIpAddress() {
        this.whenAddIpPermissionForIpAddressRequested().thenThrow(new Throwable[]{new AmazonEC2Exception("UnableToAddRule")});
        Throwable throwable = Assertions.catchThrowable(() -> this.securityGroupOperations.addInboundRule(this.inboundRuleForIpAddress));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonEC2Exception.class)).hasMessageContaining("UnableToAddRule");
    }

    @Test
    public void shouldAddRuleForIpAddress() {
        this.securityGroupOperations.addInboundRule(this.inboundRuleForIpAddress);
        ((AmazonEC2)Mockito.verify((Object)this.amazonEC2)).authorizeSecurityGroupIngress(new AuthorizeSecurityGroupIngressRequest().withGroupId("sg-9876543").withIpPermissions(new IpPermission[]{this.ipPermissionsForIpAddress()}));
    }

    private void givenUnableToCreateSecurityGroup(Exception e) {
        Mockito.when((Object)this.amazonEC2.createSecurityGroup((CreateSecurityGroupRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
    }

    private void givenCreatedGroupWithId(String groupId) {
        Mockito.when((Object)this.amazonEC2.createSecurityGroup((CreateSecurityGroupRequest)ArgumentMatchers.any())).thenReturn((Object)new CreateSecurityGroupResult().withGroupId(groupId));
    }

    private OngoingStubbing<DeleteSecurityGroupResult> whenDeleteSecurityGroupRequested(String groupId) {
        return Mockito.when((Object)this.amazonEC2.deleteSecurityGroup(new DeleteSecurityGroupRequest().withGroupId(groupId)));
    }

    private DeleteSecurityGroupResult someDeleteSecurityGroupResult() {
        return new DeleteSecurityGroupResult();
    }

    private OngoingStubbing<AuthorizeSecurityGroupIngressResult> whenAddIpPermissionForGroupRequested() {
        return Mockito.when((Object)this.amazonEC2.authorizeSecurityGroupIngress(new AuthorizeSecurityGroupIngressRequest().withGroupId("sg-9876543").withIpPermissions(new IpPermission[]{this.ipPermissionsForGroup()})));
    }

    private OngoingStubbing<AuthorizeSecurityGroupIngressResult> whenAddIpPermissionForIpAddressRequested() {
        return Mockito.when((Object)this.amazonEC2.authorizeSecurityGroupIngress(new AuthorizeSecurityGroupIngressRequest().withGroupId("sg-9876543").withIpPermissions(new IpPermission[]{this.ipPermissionsForIpAddress()})));
    }

    private IpPermission ipPermissionsForGroup() {
        return this.initialIpPermission().withUserIdGroupPairs(new UserIdGroupPair[]{new UserIdGroupPair().withGroupId("sg-8765432")});
    }

    private IpPermission ipPermissionsForIpAddress() {
        return this.initialIpPermission().withIpv4Ranges(new IpRange[]{new IpRange().withCidrIp("123.123.123.123/32")});
    }

    private IpPermission initialIpPermission() {
        return new IpPermission().withIpProtocol(this.protocol).withFromPort(Integer.valueOf(1234)).withToPort(Integer.valueOf(4321));
    }
}

