/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations.ec2;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.AmazonAutoScalingException;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationResult;
import com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationResult;
import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.OngoingStubbing;
import pl.codewise.commons.aws.cqrs.discovery.LaunchConfigurationDiscovery;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsLaunchConfiguration;
import pl.codewise.commons.aws.cqrs.operations.ec2.LaunchConfigurationOperations;

@RunWith(value=MockitoJUnitRunner.class)
public class LaunchConfigurationOperationsTest {
    private static final String NAME = "test-lc";
    private static final String NEW_NAME = "test-lc-2";
    private LaunchConfigurationOperations operations;
    @Mock
    private AmazonAutoScaling amazonAutoScaling;
    @Mock
    private LaunchConfigurationDiscovery configurationDiscovery;

    @Before
    public void setUp() {
        this.operations = new LaunchConfigurationOperations(this.amazonAutoScaling, this.configurationDiscovery);
    }

    @Test
    public void shouldReturnFalseWhenExceptionThrownDuringLaunchConfigurationCreation() {
        this.givenExceptionThrownWhileCreatingLaunchConfiguration();
        Assertions.assertThatThrownBy(() -> this.operations.createLaunchConfiguration(this.launchConfiguration())).isInstanceOf(AmazonAutoScalingException.class);
    }

    @Test
    public void shouldReturnTrueWhenSuccessfullyCreatedLaunchConfiguration() {
        this.givenSuccessfullyCreatedLaunchConfiguration();
        AwsLaunchConfiguration result = this.operations.createLaunchConfiguration(this.launchConfiguration());
        Assertions.assertThat((Object)result).isEqualTo((Object)this.launchConfiguration());
    }

    @Test
    public void shouldFailDeletingLaunchConfiguration() {
        this.whenDeleteLaunchConfigurationRequested(NAME).thenThrow(new Throwable[]{new AmazonAutoScalingException("UnableToDeleteLaunchConfiguration")});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.operations.deleteLaunchConfiguration(NAME)).isInstanceOf(AmazonAutoScalingException.class)).hasMessageContaining("UnableToDeleteLaunchConfiguration");
    }

    @Test
    public void shouldCopyLaunchConfiguration() {
        this.givenSuccessfullyCreatedLaunchConfiguration();
        AwsLaunchConfiguration launchConfigurationTemplate = this.launchConfigurationBuilder().withName(NEW_NAME).withSpotPrice("5.55").build();
        Mockito.when((Object)this.configurationDiscovery.getLaunchConfiguration(NEW_NAME)).thenReturn((Object)launchConfigurationTemplate);
        AwsLaunchConfiguration result = this.operations.copy(NAME, launchConfigurationTemplate);
        Assertions.assertThat((Object)result).isEqualTo((Object)launchConfigurationTemplate);
    }

    private void givenExceptionThrownWhileCreatingLaunchConfiguration() {
        Mockito.when((Object)this.amazonAutoScaling.createLaunchConfiguration((CreateLaunchConfigurationRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{new AmazonAutoScalingException("UnableToCreateLaunchConfiguration")});
    }

    private void givenSuccessfullyCreatedLaunchConfiguration() {
        Mockito.when((Object)this.amazonAutoScaling.createLaunchConfiguration((CreateLaunchConfigurationRequest)ArgumentMatchers.any())).thenReturn((Object)new CreateLaunchConfigurationResult());
        Mockito.when((Object)this.configurationDiscovery.getLaunchConfiguration(NAME)).thenReturn((Object)this.launchConfiguration());
    }

    private AwsLaunchConfiguration launchConfiguration() {
        return this.launchConfigurationBuilder().build();
    }

    private AwsLaunchConfiguration.Builder launchConfigurationBuilder() {
        return new AwsLaunchConfiguration.Builder().withName(NAME).withImageId("img-1").withIamInstanceProfile("iam-profile-test").withKeyName("some-key-pair").withInstanceType("t2.small").withSpotPrice("4.44").withSecurityGroupIds(Arrays.asList("sg-1", "sg-2")).withUserData("some user data").withAssociatePublicIpAddress(Boolean.valueOf(false));
    }

    private OngoingStubbing<DeleteLaunchConfigurationResult> whenDeleteLaunchConfigurationRequested(String name) {
        return Mockito.when((Object)this.amazonAutoScaling.deleteLaunchConfiguration(new DeleteLaunchConfigurationRequest().withLaunchConfigurationName(name)));
    }
}

