/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest;
import com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceResult;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.NetworkInterface;
import com.amazonaws.services.ec2.model.Tag;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import pl.codewise.commons.aws.cqrs.discovery.Ec2Discovery;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;
import pl.codewise.commons.aws.cqrs.model.AwsNetworkInterface;
import pl.codewise.commons.aws.cqrs.model.AwsNetworkInterfaceAttachment;
import pl.codewise.commons.aws.cqrs.operations.ec2.InstanceOperations;

public class InstanceOperationsTest {
    private InstanceOperations operations;
    private AmazonEC2 amazonEC2;
    private Ec2Discovery ec2Discovery;

    @Before
    public void setUp() {
        this.amazonEC2 = (AmazonEC2)Mockito.mock(AmazonEC2.class);
        this.ec2Discovery = (Ec2Discovery)Mockito.mock(Ec2Discovery.class);
        this.operations = new InstanceOperations(this.amazonEC2, this.ec2Discovery);
    }

    @Test
    public void shouldCreatePrivateIpAndAssignToNetworkInterface() {
        String networkInterfaceId = "networkInterfaceId";
        this.operations.createPrivateIpAndAssignToNetworkInterface(networkInterfaceId);
        ArgumentCaptor captor = ArgumentCaptor.forClass(AssignPrivateIpAddressesRequest.class);
        ((AmazonEC2)Mockito.verify((Object)this.amazonEC2)).assignPrivateIpAddresses((AssignPrivateIpAddressesRequest)captor.capture());
        Assertions.assertThat((String)((AssignPrivateIpAddressesRequest)captor.getValue()).getNetworkInterfaceId()).isEqualTo((Object)networkInterfaceId);
        Assertions.assertThat((Integer)((AssignPrivateIpAddressesRequest)captor.getValue()).getSecondaryPrivateIpAddressCount()).isEqualTo(1);
    }

    @Test
    public void shouldCreateMultiplyPrivateIpsAndAssignToNetworkInterface() {
        String networkInterfaceId = "networkInterfaceId";
        this.operations.createPrivateIpsAndAssignToNetworkInterface(networkInterfaceId, 5);
        ArgumentCaptor captor = ArgumentCaptor.forClass(AssignPrivateIpAddressesRequest.class);
        ((AmazonEC2)Mockito.verify((Object)this.amazonEC2)).assignPrivateIpAddresses((AssignPrivateIpAddressesRequest)captor.capture());
        Assertions.assertThat((String)((AssignPrivateIpAddressesRequest)captor.getValue()).getNetworkInterfaceId()).isEqualTo((Object)networkInterfaceId);
        Assertions.assertThat((Integer)((AssignPrivateIpAddressesRequest)captor.getValue()).getSecondaryPrivateIpAddressCount()).isEqualTo(5);
    }

    @Test
    public void shouldCreateNetworkInterfaceAndAssignItToInstance() {
        String instanceId = "instanceId";
        AwsInstance instance = new AwsInstance.Builder().withNetworkInterfaces(Arrays.asList(new AwsNetworkInterface.Builder().withAttachment(new AwsNetworkInterfaceAttachment.Builder().withDeviceIndex(Integer.valueOf(0)).build()).build(), new AwsNetworkInterface.Builder().withAttachment(new AwsNetworkInterfaceAttachment.Builder().withDeviceIndex(Integer.valueOf(2)).build()).build())).build();
        Mockito.when((Object)this.ec2Discovery.getInstance(instanceId)).thenReturn((Object)instance);
        String newInterfaceId = "newInterfaceId";
        NetworkInterface newNetworkInterface = new NetworkInterface().withNetworkInterfaceId(newInterfaceId);
        Mockito.when((Object)this.amazonEC2.createNetworkInterface((CreateNetworkInterfaceRequest)ArgumentMatchers.any())).thenReturn((Object)new CreateNetworkInterfaceResult().withNetworkInterface(newNetworkInterface));
        this.operations.createNetworkInterfaceAndAssignToInstance(instanceId, Collections.singletonList("sg-id1"));
        ArgumentCaptor captor = ArgumentCaptor.forClass(AttachNetworkInterfaceRequest.class);
        ((AmazonEC2)Mockito.verify((Object)this.amazonEC2)).attachNetworkInterface((AttachNetworkInterfaceRequest)captor.capture());
        Assertions.assertThat((String)((AttachNetworkInterfaceRequest)captor.getValue()).getNetworkInterfaceId()).isEqualTo((Object)newInterfaceId);
        Assertions.assertThat((Integer)((AttachNetworkInterfaceRequest)captor.getValue()).getDeviceIndex()).isEqualTo(1);
    }

    @Test
    public void shouldSetInstanceNameTag() {
        String instanceId = "id-12345";
        CreateTagsRequest expectedRequest = new CreateTagsRequest().withResources(new String[]{instanceId}).withTags(new Tag[]{new Tag().withKey("Name").withValue("new-instance-name")});
        this.operations.tagInstanceName(instanceId, "new-instance-name");
        ((AmazonEC2)Mockito.verify((Object)this.amazonEC2)).createTags(expectedRequest);
    }
}

