/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import pl.codewise.commons.aws.cqrs.discovery.Ec2Discovery;
import pl.codewise.commons.aws.cqrs.model.AwsNetworkInterface;
import pl.codewise.commons.aws.cqrs.model.AwsNetworkInterfaceAttachment;
import pl.codewise.commons.aws.cqrs.operations.ec2.InstanceOperations;

@RunWith(value=Parameterized.class)
public class InstanceOperationsFindingIndexesTest {
    @Parameterized.Parameter
    public List<Integer> indexes;
    @Parameterized.Parameter(value=1)
    public Integer expectedFirstFreeIndex;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({Collections.emptyList(), 0}, {Collections.singletonList(0), 1}, {Collections.singletonList(1), 0}, {Arrays.asList(0, 1, 2, 3, 4, 5), 6}, {Arrays.asList(0, 1, 3, 4, 5), 2}, {Arrays.asList(0, 1, 0, 1, 2, 1, 0), 3}, {Arrays.asList(1, 1, 1, 1, 1), 0}, {Arrays.asList(4, 3, 2, 1, 0), 5});
    }

    @Test
    public void shouldFindFirstDeviceIndex() {
        InstanceOperations operations = new InstanceOperations((AmazonEC2)Mockito.mock(AmazonEC2.class), (Ec2Discovery)Mockito.mock(Ec2Discovery.class));
        List interfaces = this.indexes.stream().map(ifc -> new AwsNetworkInterfaceAttachment.Builder().withDeviceIndex(ifc).build()).map(att -> new AwsNetworkInterface.Builder().withAttachment(att).build()).collect(Collectors.toList());
        int firstFreeDeviceIndex = operations.findFirstFreeDeviceIndex(interfaces);
        Assertions.assertThat((int)firstFreeDeviceIndex).isEqualTo((Object)this.expectedFirstFreeIndex);
    }
}

