/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AllocateAddressRequest;
import com.amazonaws.services.ec2.model.AllocateAddressResult;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import pl.codewise.commons.aws.cqrs.discovery.ec2.AddressDiscovery;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsAddress;
import pl.codewise.commons.aws.cqrs.operations.ec2.AddressOperations;

public class AddressOperationsTest {
    private static final String US_EAST_1 = "us-east-1";
    private AmazonEC2 amazonEC2;
    private AddressOperations operations;
    private AddressDiscovery addressDiscovery;

    @Before
    public void setUp() {
        this.amazonEC2 = (AmazonEC2)Mockito.mock(AmazonEC2.class);
        this.addressDiscovery = (AddressDiscovery)Mockito.mock(AddressDiscovery.class);
        this.operations = new AddressOperations(US_EAST_1, this.amazonEC2, this.addressDiscovery);
    }

    @Test
    public void shouldAllocateAddress() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(AllocateAddressRequest.class);
        String publicIp = "ip-tratata";
        Mockito.when((Object)this.amazonEC2.allocateAddress((AllocateAddressRequest)ArgumentMatchers.any())).thenReturn((Object)new AllocateAddressResult().withPublicIp("ip-tratata"));
        AwsAddress awsAddress = this.operations.allocateNewAddress(AddressOperations.DomainType.VPC);
        ((AmazonEC2)Mockito.verify((Object)this.amazonEC2)).allocateAddress((AllocateAddressRequest)captor.capture());
        Assertions.assertThat((String)((AllocateAddressRequest)captor.getValue()).getDomain()).isEqualTo((Object)"vpc");
        Assertions.assertThat((String)awsAddress.getPublicIp()).isEqualTo((Object)"ip-tratata");
        Assertions.assertThat((String)awsAddress.getRegion()).isEqualTo((Object)US_EAST_1);
    }

    @Test
    public void shouldAssociatePublicIpToPrivateIp() {
        String publicIp = "publicIp";
        String networkInterfaceId = "networkInterfaceId";
        String privateIp = "privateIp";
        String allocationID = "allocationID";
        Mockito.when((Object)this.addressDiscovery.getAddressByPublicIp(publicIp)).thenReturn((Object)new AwsAddress.Builder().withAllocationId(allocationID).build());
        this.operations.associatePublicIpToPrivateIp(publicIp, networkInterfaceId, privateIp);
        ArgumentCaptor captor = ArgumentCaptor.forClass(AssociateAddressRequest.class);
        ((AmazonEC2)Mockito.verify((Object)this.amazonEC2)).associateAddress((AssociateAddressRequest)captor.capture());
        Assertions.assertThat((String)((AssociateAddressRequest)captor.getValue()).getAllocationId()).isEqualTo((Object)allocationID);
        Assertions.assertThat((String)((AssociateAddressRequest)captor.getValue()).getNetworkInterfaceId()).isEqualTo((Object)networkInterfaceId);
        Assertions.assertThat((String)((AssociateAddressRequest)captor.getValue()).getPrivateIpAddress()).isEqualTo((Object)privateIp);
    }
}

