/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.model.AliasTarget;
import com.amazonaws.services.route53.model.Change;
import com.amazonaws.services.route53.model.ChangeInfo;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsResult;
import com.amazonaws.services.route53.model.ChangeTagsForResourceRequest;
import com.amazonaws.services.route53.model.CreateHealthCheckRequest;
import com.amazonaws.services.route53.model.CreateHealthCheckResult;
import com.amazonaws.services.route53.model.DeleteHostedZoneRequest;
import com.amazonaws.services.route53.model.DeleteHostedZoneResult;
import com.amazonaws.services.route53.model.HealthCheck;
import com.amazonaws.services.route53.model.HealthCheckConfig;
import com.amazonaws.services.route53.model.HealthCheckType;
import com.amazonaws.services.route53.model.ResourceRecord;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import com.amazonaws.services.route53.model.Tag;
import com.amazonaws.services.route53.model.TagResourceType;
import com.amazonaws.services.route53.model.UpdateHealthCheckRequest;
import com.amazonaws.services.route53.model.UpdateHealthCheckResult;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import pl.codewise.commons.aws.cqrs.model.route53.AwsAliasTarget;
import pl.codewise.commons.aws.cqrs.model.route53.AwsChangeInfo;
import pl.codewise.commons.aws.cqrs.model.route53.AwsHealthCheck;
import pl.codewise.commons.aws.cqrs.model.route53.AwsRecordSet;
import pl.codewise.commons.aws.cqrs.model.route53.AwsResourceRecord;
import pl.codewise.commons.aws.cqrs.model.route53.AwsUpdateHealthCheckRequest;
import pl.codewise.commons.aws.cqrs.operations.Route53Operations;

public class Route53OperationsTest {
    private Route53Operations operations;
    private AmazonRoute53 route53;

    @Before
    public void setUp() {
        this.route53 = (AmazonRoute53)Mockito.mock(AmazonRoute53.class);
        this.operations = new Route53Operations(this.route53);
    }

    @Test
    public void shouldUpsertChanges() {
        AwsRecordSet recordSet1 = new AwsRecordSet.Builder().withName("name1").withRegion("region1").withResourceRecords(Arrays.asList(new AwsResourceRecord("value1"), new AwsResourceRecord("value2"))).withSetIdentifier("identifier1").withHealthCheckId("healthCheckId").withTtl(Long.valueOf(13L)).withType("A").build();
        AwsRecordSet recordSet2 = new AwsRecordSet.Builder().withName("name2").withRegion("region2").withResourceRecords(Collections.singletonList(new AwsResourceRecord("value3"))).withSetIdentifier("identifier2").withMultiValueAnswer(Boolean.valueOf(true)).withTtl(Long.valueOf(24L)).withType("NX").build();
        AwsRecordSet recordSet3 = new AwsRecordSet.Builder().withName("name3").withRegion("region3").withAliasTarget(new AwsAliasTarget("hostedZoneId", "someAliasTarget", Boolean.valueOf(true))).withSetIdentifier("identifier3").withTtl(Long.valueOf(35L)).withType("A").build();
        Mockito.when((Object)this.route53.changeResourceRecordSets((ChangeResourceRecordSetsRequest)ArgumentMatchers.any())).thenReturn((Object)new ChangeResourceRecordSetsResult().withChangeInfo(new ChangeInfo()));
        this.operations.upsertChanges("zoneId", Arrays.asList(recordSet1, recordSet2, recordSet3));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ChangeResourceRecordSetsRequest.class);
        ((AmazonRoute53)Mockito.verify((Object)this.route53)).changeResourceRecordSets((ChangeResourceRecordSetsRequest)captor.capture());
        Assertions.assertThat((List)captor.getAllValues()).hasSize(1);
        ChangeResourceRecordSetsRequest request = (ChangeResourceRecordSetsRequest)captor.getAllValues().get(0);
        Assertions.assertThat((String)request.getHostedZoneId()).isEqualTo((Object)"zoneId");
        Assertions.assertThat((List)request.getChangeBatch().getChanges()).hasSize(3);
        Change ch1 = (Change)request.getChangeBatch().getChanges().get(0);
        Assertions.assertThat((String)ch1.getAction()).isEqualTo((Object)"UPSERT");
        ResourceRecordSet chrs1 = ch1.getResourceRecordSet();
        Assertions.assertThat((String)chrs1.getName()).isEqualTo((Object)"name1");
        Assertions.assertThat((String)chrs1.getRegion()).isEqualTo((Object)"region1");
        Assertions.assertThat((String)chrs1.getSetIdentifier()).isEqualTo((Object)"identifier1");
        Assertions.assertThat((Long)chrs1.getTTL()).isEqualTo(13L);
        Assertions.assertThat((String)chrs1.getType()).isEqualTo((Object)"A");
        Assertions.assertThat((String)chrs1.getHealthCheckId()).isEqualTo((Object)"healthCheckId");
        Assertions.assertThat(chrs1.getResourceRecords().stream().map(ResourceRecord::getValue)).containsExactly((Object[])new String[]{"value1", "value2"});
        Change ch2 = (Change)request.getChangeBatch().getChanges().get(1);
        Assertions.assertThat((String)ch2.getAction()).isEqualTo((Object)"UPSERT");
        ResourceRecordSet chrs2 = ch2.getResourceRecordSet();
        Assertions.assertThat((String)chrs2.getName()).isEqualTo((Object)"name2");
        Assertions.assertThat((String)chrs2.getRegion()).isEqualTo((Object)"region2");
        Assertions.assertThat((String)chrs2.getSetIdentifier()).isEqualTo((Object)"identifier2");
        Assertions.assertThat((Long)chrs2.getTTL()).isEqualTo(24L);
        Assertions.assertThat((String)chrs2.getType()).isEqualTo((Object)"NX");
        Assertions.assertThat((Boolean)chrs2.getMultiValueAnswer()).isTrue();
        Assertions.assertThat(chrs2.getResourceRecords().stream().map(ResourceRecord::getValue)).containsExactly((Object[])new String[]{"value3"});
        Change ch3 = (Change)request.getChangeBatch().getChanges().get(2);
        Assertions.assertThat((String)ch3.getAction()).isEqualTo((Object)"UPSERT");
        ResourceRecordSet chrs3 = ch3.getResourceRecordSet();
        Assertions.assertThat((String)chrs3.getName()).isEqualTo((Object)"name3");
        Assertions.assertThat((String)chrs3.getRegion()).isEqualTo((Object)"region3");
        Assertions.assertThat((String)chrs3.getSetIdentifier()).isEqualTo((Object)"identifier3");
        Assertions.assertThat((Long)chrs3.getTTL()).isEqualTo(35L);
        Assertions.assertThat((String)chrs3.getType()).isEqualTo((Object)"A");
        Assertions.assertThat((Object)chrs3.getAliasTarget()).isEqualTo((Object)this.aliasTarget("hostedZoneId", "someAliasTarget", true));
        Assertions.assertThat((List)chrs3.getResourceRecords()).isEmpty();
    }

    @Test
    public void shouldRemoveRecordSets() {
        AwsRecordSet recordSet1 = new AwsRecordSet.Builder().withName("name1").withRegion("region1").withResourceRecords(Arrays.asList(new AwsResourceRecord("value1"), new AwsResourceRecord("value2"))).withSetIdentifier("identifier1").withTtl(Long.valueOf(13L)).withType("A").build();
        AwsRecordSet recordSet2 = new AwsRecordSet.Builder().withName("name2").withRegion("region2").withResourceRecords(Collections.singletonList(new AwsResourceRecord("value3"))).withSetIdentifier("identifier2").withTtl(Long.valueOf(24L)).withType("NX").build();
        AwsRecordSet recordSet3 = new AwsRecordSet.Builder().withName("name3").withRegion("region3").withAliasTarget(new AwsAliasTarget("hostedZoneId", "someAliasTarget", Boolean.valueOf(true))).withSetIdentifier("identifier3").withTtl(Long.valueOf(35L)).withType("A").build();
        Mockito.when((Object)this.route53.changeResourceRecordSets((ChangeResourceRecordSetsRequest)ArgumentMatchers.any())).thenReturn((Object)new ChangeResourceRecordSetsResult().withChangeInfo(new ChangeInfo()));
        this.operations.removeRecordSets("zoneId", Arrays.asList(recordSet1, recordSet2, recordSet3));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ChangeResourceRecordSetsRequest.class);
        ((AmazonRoute53)Mockito.verify((Object)this.route53)).changeResourceRecordSets((ChangeResourceRecordSetsRequest)captor.capture());
        Assertions.assertThat((List)captor.getAllValues()).hasSize(1);
        ChangeResourceRecordSetsRequest request = (ChangeResourceRecordSetsRequest)captor.getAllValues().get(0);
        Assertions.assertThat((String)request.getHostedZoneId()).isEqualTo((Object)"zoneId");
        Assertions.assertThat((List)request.getChangeBatch().getChanges()).hasSize(3);
        Change ch1 = (Change)request.getChangeBatch().getChanges().get(0);
        Assertions.assertThat((String)ch1.getAction()).isEqualTo((Object)"DELETE");
        Change ch2 = (Change)request.getChangeBatch().getChanges().get(1);
        Assertions.assertThat((String)ch2.getAction()).isEqualTo((Object)"DELETE");
        Change ch3 = (Change)request.getChangeBatch().getChanges().get(2);
        Assertions.assertThat((String)ch3.getAction()).isEqualTo((Object)"DELETE");
    }

    @Test
    public void shouldCreateHealthCheck() {
        String callerReference = UUID.randomUUID().toString();
        String healthCheckName = "healthCheckName";
        String ipAddress = "192.168.1.1";
        String path = "/path/to/check";
        int failureThreshold = 20;
        HashSet regions = Sets.newHashSet((Object[])new String[]{"us-east-1", "eu-central-1"});
        String healthCheckId = "healthCheckId";
        Mockito.when((Object)this.route53.createHealthCheck((CreateHealthCheckRequest)ArgumentMatchers.any())).thenReturn((Object)new CreateHealthCheckResult().withHealthCheck(new HealthCheck().withId(healthCheckId)));
        AwsHealthCheck awsHealthCheck = this.operations.createHttpHealthCheck(healthCheckName, ipAddress, path, callerReference, (Set)regions, Integer.valueOf(failureThreshold));
        Assertions.assertThat((Object)awsHealthCheck).isEqualTo((Object)new AwsHealthCheck(healthCheckId));
        ((AmazonRoute53)Mockito.verify((Object)this.route53)).createHealthCheck(new CreateHealthCheckRequest().withCallerReference(callerReference).withHealthCheckConfig(new HealthCheckConfig().withIPAddress(ipAddress).withPort(Integer.valueOf(80)).withType(HealthCheckType.HTTP).withResourcePath(path).withRegions((Collection)regions).withFailureThreshold(Integer.valueOf(failureThreshold))));
        ((AmazonRoute53)Mockito.verify((Object)this.route53)).changeTagsForResource(new ChangeTagsForResourceRequest().withResourceType(TagResourceType.Healthcheck).withResourceId(healthCheckId).withAddTags(new Tag[]{new Tag().withKey("Name").withValue(healthCheckName)}));
    }

    @Test
    public void shouldModifyHealthCheck() {
        String healthCheckId = "health-check-id";
        int port = 12345;
        AwsUpdateHealthCheckRequest request = new AwsUpdateHealthCheckRequest.Builder().setHealthCheckId(healthCheckId).setPort(Integer.valueOf(port)).build();
        Mockito.when((Object)this.route53.updateHealthCheck((UpdateHealthCheckRequest)ArgumentMatchers.any())).thenReturn((Object)new UpdateHealthCheckResult().withHealthCheck(new HealthCheck().withId(healthCheckId)));
        AwsHealthCheck healthCheck = this.operations.modifyHealthCheck(request);
        Assertions.assertThat((String)healthCheck.getId()).isEqualTo((Object)healthCheckId);
        ((AmazonRoute53)Mockito.verify((Object)this.route53)).updateHealthCheck(new UpdateHealthCheckRequest().withHealthCheckId(healthCheckId).withPort(Integer.valueOf(port)));
    }

    @Test
    public void shouldRemoveHostedZone() {
        String hostedZoneId = "hostedZoneId";
        String operationStatus = "Deleted!";
        String operationId = "operationId";
        Mockito.when((Object)this.route53.deleteHostedZone(new DeleteHostedZoneRequest().withId(hostedZoneId))).thenReturn((Object)new DeleteHostedZoneResult().withChangeInfo(new ChangeInfo().withStatus(operationStatus).withId(operationId)));
        AwsChangeInfo awsChangeInfo = this.operations.removeHostedZone(hostedZoneId);
        Assertions.assertThat((String)awsChangeInfo.getId()).isEqualTo((Object)operationId);
        Assertions.assertThat((String)awsChangeInfo.getStatus()).isEqualTo((Object)operationStatus);
    }

    private AliasTarget aliasTarget(String hostedZoneId, String dnsTarget, boolean evaluateTargetHealth) {
        AliasTarget aliasTarget = new AliasTarget(hostedZoneId, dnsTarget);
        aliasTarget.setEvaluateTargetHealth(Boolean.valueOf(evaluateTargetHealth));
        return aliasTarget;
    }
}

