/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.route53domains.model.ContactDetail;
import com.amazonaws.services.route53domains.model.ContactType;
import com.amazonaws.services.route53domains.model.DisableDomainAutoRenewRequest;
import com.amazonaws.services.route53domains.model.RegisterDomainRequest;
import com.amazonaws.services.route53domains.model.RegisterDomainResult;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import pl.codewise.commons.aws.cqrs.model.route53.AwsContactDetails;
import pl.codewise.commons.aws.cqrs.model.route53.AwsContactType;
import pl.codewise.commons.aws.cqrs.model.route53.AwsRegisterDomainRequest;
import pl.codewise.commons.aws.cqrs.model.route53.AwsRegisterDomainResult;
import pl.codewise.commons.aws.cqrs.operations.Route53DomainsOperations;

public class Route53DomainsOperationsTest {
    private AmazonRoute53Domains amazonRoute53Domains;
    private Route53DomainsOperations route53DomainsOperations;

    @Before
    public void setUp() {
        this.amazonRoute53Domains = (AmazonRoute53Domains)Mockito.mock(AmazonRoute53Domains.class);
        this.route53DomainsOperations = new Route53DomainsOperations(this.amazonRoute53Domains);
    }

    @Test
    public void shouldRegisterDomain() {
        AwsRegisterDomainRequest request = new AwsRegisterDomainRequest.Builder().withDomainName("domain.name").withAutoRenew(true).withDurationYears(15).withProtectAdminContact(true).withProtectRegistrantContact(true).withProtectTechContact(true).withTechContact(new AwsContactDetails.Builder().withFirstName("tech first").withLastName("tech last").withOrganizationName("tech org").withPhoneNumber("tech phone").withContactType(AwsContactType.ASSOCIATION).withCountryCode("PL").withCity("Krakow").withAddressLine1("tech line 1").withAddressLine2("tech line 2").withZipCode("tech zip").build()).withRegistrantContact(new AwsContactDetails.Builder().withFirstName("registrant first").withLastName("registrant last").withOrganizationName("registrant org").withPhoneNumber("registrant phone").withContactType(AwsContactType.PERSON).withCountryCode("FR").withCity("Paris").withAddressLine1("registrant line 1").withAddressLine2("registrant line 2").withZipCode("registrant zip").build()).withAdminContact(new AwsContactDetails.Builder().withFirstName("admin first").withLastName("admin last").withOrganizationName("admin org").withPhoneNumber("admin phone").withContactType(AwsContactType.COMPANY).withCountryCode("DE").withCity("Berlin").withAddressLine1("admin line 1").withAddressLine2("admin line 2").withZipCode("admin zip").build()).build();
        Mockito.when((Object)this.amazonRoute53Domains.registerDomain((RegisterDomainRequest)ArgumentMatchers.any())).thenReturn((Object)new RegisterDomainResult().withOperationId("operation id"));
        AwsRegisterDomainResult result = this.route53DomainsOperations.registerDomain(request);
        RegisterDomainRequest expectedAmazonRequest = new RegisterDomainRequest().withDomainName("domain.name").withAutoRenew(Boolean.valueOf(true)).withDurationInYears(Integer.valueOf(15)).withPrivacyProtectAdminContact(Boolean.valueOf(true)).withPrivacyProtectRegistrantContact(Boolean.valueOf(true)).withPrivacyProtectTechContact(Boolean.valueOf(true)).withTechContact(new ContactDetail().withFirstName("tech first").withLastName("tech last").withOrganizationName("tech org").withPhoneNumber("tech phone").withContactType(ContactType.ASSOCIATION).withCountryCode("PL").withCity("Krakow").withAddressLine1("tech line 1").withAddressLine2("tech line 2").withZipCode("tech zip")).withRegistrantContact(new ContactDetail().withFirstName("registrant first").withLastName("registrant last").withOrganizationName("registrant org").withPhoneNumber("registrant phone").withContactType(ContactType.PERSON).withCountryCode("FR").withCity("Paris").withAddressLine1("registrant line 1").withAddressLine2("registrant line 2").withZipCode("registrant zip")).withAdminContact(new ContactDetail().withFirstName("admin first").withLastName("admin last").withOrganizationName("admin org").withPhoneNumber("admin phone").withContactType(ContactType.COMPANY).withCountryCode("DE").withCity("Berlin").withAddressLine1("admin line 1").withAddressLine2("admin line 2").withZipCode("admin zip"));
        ((AmazonRoute53Domains)Mockito.verify((Object)this.amazonRoute53Domains)).registerDomain((RegisterDomainRequest)ArgumentMatchers.eq((Object)expectedAmazonRequest));
        Assertions.assertThat((String)result.getOperationId()).isEqualTo((Object)"operation id");
    }

    @Test
    public void shouldDisableDomainAutoRenewal() {
        String domainName = "domain.com";
        this.route53DomainsOperations.disableDomainAutoRenewal(domainName);
        ((AmazonRoute53Domains)Mockito.verify((Object)this.amazonRoute53Domains)).disableDomainAutoRenew(new DisableDomainAutoRenewRequest().withDomainName(domainName));
    }
}

