/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.AmazonIdentityManagementException;
import com.amazonaws.services.identitymanagement.model.AttachRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.AttachRolePolicyResult;
import com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.CreateInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.CreateRoleRequest;
import com.amazonaws.services.identitymanagement.model.CreateRoleResult;
import com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.DeleteRoleRequest;
import com.amazonaws.services.identitymanagement.model.DeleteRoleResult;
import com.amazonaws.services.identitymanagement.model.DetachRolePolicyRequest;
import com.amazonaws.services.identitymanagement.model.DetachRolePolicyResult;
import com.amazonaws.services.identitymanagement.model.InstanceProfile;
import com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.Role;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.OngoingStubbing;
import pl.codewise.commons.aws.cqrs.discovery.IamDiscovery;
import pl.codewise.commons.aws.cqrs.model.iam.AwsIamRole;
import pl.codewise.commons.aws.cqrs.model.iam.AwsInstanceProfile;
import pl.codewise.commons.aws.cqrs.operations.IamOperations;

@RunWith(value=MockitoJUnitRunner.class)
public class IamOperationsTest {
    private final String policy1 = "test-policy-1";
    private final String policy2 = "test-policy-2";
    private final String arnPrefix = "arn:aws:iam::123456789012:";
    private final String role1 = "test-role-1";
    private final String role2 = "test-role-2";
    private final String profile1 = "test-profile";
    private IamOperations iamOperations;
    @Mock
    private IamDiscovery iamDiscovery;
    @Mock
    private AmazonIdentityManagement amazonIdentityManagement;

    @Before
    public void setUp() {
        this.iamOperations = new IamOperations(this.iamDiscovery, this.amazonIdentityManagement);
    }

    @Test
    public void shouldReturnEmptyWhenUnableToCreateInstanceProfile() {
        this.givenExceptionThrownDuringInstanceProfileCreation((Exception)new AmazonIdentityManagementException("UnableToCreate"));
        Throwable throwable = Assertions.catchThrowable(() -> this.iamOperations.createInstanceProfile("test-profile"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonIdentityManagementException.class)).hasMessageContaining("UnableToCreate");
    }

    @Test
    public void shouldReturnCreatedInstanceProfileWhenCreationSuccessful() {
        this.givenSuccessfulInstanceProfileCreation("test-profile");
        AwsInstanceProfile profile = this.iamOperations.createInstanceProfile("test-profile");
        ((ObjectAssert)Assertions.assertThat((Object)profile).as("Result of new instance profile creation when attempt was successful", new Object[0])).isEqualTo((Object)new AwsInstanceProfile("test-profile", "arn:aws:iam::123456789012:test-profile"));
    }

    @Test
    public void shouldFailDeletingInstanceProfile() {
        this.whenDeleteInstanceProfileRequested().thenThrow(new Throwable[]{new AmazonIdentityManagementException("UnableToDeleteInstanceProfile")});
        Throwable throwable = Assertions.catchThrowable(() -> this.iamOperations.deleteInstanceProfile("test-profile"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonIdentityManagementException.class)).hasMessageContaining("UnableToDeleteInstanceProfile");
    }

    @Test
    public void shouldDeleteInstanceProfile() {
        this.whenDeleteInstanceProfileRequested().thenReturn((Object)this.someDeleteInstanceProfileResult());
        this.iamOperations.deleteInstanceProfile("test-profile");
        ((AmazonIdentityManagement)Mockito.verify((Object)this.amazonIdentityManagement)).deleteInstanceProfile(new DeleteInstanceProfileRequest().withInstanceProfileName("test-profile"));
    }

    @Test
    public void shouldReturnEmptyWhenUnableToCreateRole() {
        this.givenExceptionThrownDuringRoleCreation((Exception)new AmazonIdentityManagementException("UnableToCreate"));
        Throwable throwable = Assertions.catchThrowable(() -> this.iamOperations.createRole("test-role-1"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonIdentityManagementException.class)).hasMessageContaining("UnableToCreate");
    }

    @Test
    public void shouldReturnCreatedRoleWhenCreationSuccessful() {
        this.givenSuccessfulRoleCreation("test-role-1");
        AwsIamRole role = this.iamOperations.createRole("test-role-1");
        ((ObjectAssert)Assertions.assertThat((Object)role).as("Result of new role creation when the attempt was successful", new Object[0])).isEqualTo((Object)new AwsIamRole("test-role-1"));
    }

    @Test
    public void shouldFailDeletingRole() {
        this.whenDeleteRoleRequested().thenThrow(new Throwable[]{new AmazonIdentityManagementException("UnableToDeleteRole")});
        Throwable throwable = Assertions.catchThrowable(() -> this.iamOperations.deleteRole("test-role-1"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonIdentityManagementException.class)).hasMessageContaining("UnableToDeleteRole");
    }

    @Test
    public void shouldDeleteRole() {
        this.whenDeleteRoleRequested().thenReturn((Object)this.someDeleteRoleResult());
        this.iamOperations.deleteRole("test-role-1");
        ((AmazonIdentityManagement)Mockito.verify((Object)this.amazonIdentityManagement)).deleteRole(new DeleteRoleRequest().withRoleName("test-role-1"));
    }

    @Test
    public void shouldReturnFalseWhenUnableToAddRoleToInstanceProfile() {
        this.givenExceptionThrownWhenAddingRoleToInstanceProfile((Exception)new AmazonIdentityManagementException("UnableToAddRoleToInstanceProfile"));
        Throwable throwable = Assertions.catchThrowable(() -> this.iamOperations.addRoleToInstanceProfile("test-role-1", "test-profile"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonIdentityManagementException.class)).hasMessageContaining("UnableToAddRoleToInstanceProfile");
    }

    @Test
    public void shouldReturnTrueWhenSuccessfullyAddedRoleToInstanceProfile() {
        this.givenSuccessfulAdditionOfRoleToPolicy();
        this.iamOperations.addRoleToInstanceProfile("test-role-1", "test-profile");
        ((AmazonIdentityManagement)Mockito.verify((Object)this.amazonIdentityManagement)).addRoleToInstanceProfile(new AddRoleToInstanceProfileRequest().withRoleName("test-role-1").withInstanceProfileName("test-profile"));
    }

    @Test
    public void shouldFailRemovingRolesFromInstanceProfile() {
        Mockito.when((Object)this.iamDiscovery.getInstanceProfileRoles("test-profile")).thenReturn(Collections.singletonList("test-role-1"));
        this.whenRemoveRoleFromInstanceProfileRequested("test-role-1").thenThrow(new Throwable[]{new AmazonIdentityManagementException("UnableToRemoveRoleFromProfile")});
        Throwable throwable = Assertions.catchThrowable(() -> this.iamOperations.removeRolesFromInstanceProfile("test-profile"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonIdentityManagementException.class)).hasMessageContaining("UnableToRemoveRoleFromProfile");
    }

    @Test
    public void shouldRemoveRolesFromInstanceProfile() {
        Mockito.when((Object)this.iamDiscovery.getInstanceProfileRoles("test-profile")).thenReturn(Arrays.asList("test-role-1", "test-role-2"));
        this.whenRemoveRoleFromInstanceProfileRequested("test-role-1").thenReturn((Object)this.someRemoveRoleFromInstanceProfileResult());
        this.whenRemoveRoleFromInstanceProfileRequested("test-role-2").thenReturn((Object)this.someRemoveRoleFromInstanceProfileResult());
        this.iamOperations.removeRolesFromInstanceProfile("test-profile");
        ((AmazonIdentityManagement)Mockito.verify((Object)this.amazonIdentityManagement)).removeRoleFromInstanceProfile(new RemoveRoleFromInstanceProfileRequest().withInstanceProfileName("test-profile").withRoleName("test-role-1"));
        ((AmazonIdentityManagement)Mockito.verify((Object)this.amazonIdentityManagement)).removeRoleFromInstanceProfile(new RemoveRoleFromInstanceProfileRequest().withInstanceProfileName("test-profile").withRoleName("test-role-2"));
    }

    @Test
    public void shouldReturnFalseWhenPolicyDoesNotExist() {
        this.givenNoPolicies();
        boolean successfullyAttached = this.iamOperations.attachPolicyToRole("test-policy-1", "test-role-1");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)successfullyAttached).as("Successful result of attaching non-existing policy", new Object[0])).isFalse();
    }

    @Test
    public void shouldReturnFalseWhenUnableToAttachPolicyToRole() {
        this.givenPolicies("test-policy-1");
        this.givenExceptionThrownWhenAttachingPolicy((Exception)new AmazonIdentityManagementException("UnableToAttachPolicy"));
        Throwable throwable = Assertions.catchThrowable(() -> this.iamOperations.attachPolicyToRole("test-policy-1", "test-role-1"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonIdentityManagementException.class)).hasMessageContaining("UnableToAttachPolicy");
    }

    @Test
    public void shouldReturnTrueWhenSuccessfullyAttachedPolicy() {
        this.givenPolicies("test-policy-1");
        this.givenSuccessfulAttachmentOfAPolicy();
        boolean successfullyAttached = this.iamOperations.attachPolicyToRole("test-policy-1", "test-role-1");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)successfullyAttached).as("Successful result of attaching a policy to a role", new Object[0])).isTrue();
    }

    @Test
    public void shouldFailWhenUnableToDetachPolicies() {
        Mockito.when((Object)this.iamDiscovery.getAttachedPoliciesArnsForRole("test-role-1")).thenReturn(Arrays.asList(this.prefixed("test-policy-1"), this.prefixed("test-policy-2")));
        this.whenDetachRolePolicyRequested("test-policy-1", "test-role-1").thenThrow(new Throwable[]{new AmazonIdentityManagementException("NoSuchRole")});
        Throwable throwable = Assertions.catchThrowable(() -> this.iamOperations.detachAllPoliciesFromRole("test-role-1"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonIdentityManagementException.class)).hasMessageContaining("NoSuchRole");
    }

    @Test
    public void shouldDetachPolicyFromRole() {
        Mockito.when((Object)this.iamDiscovery.getAttachedPoliciesArnsForRole("test-role-1")).thenReturn(Arrays.asList(this.prefixed("test-policy-1"), this.prefixed("test-policy-2")));
        this.whenDetachRolePolicyRequested("test-policy-1", "test-role-1").thenReturn((Object)this.someDetachRolePolicyResult());
        this.whenDetachRolePolicyRequested("test-policy-2", "test-role-1").thenReturn((Object)this.someDetachRolePolicyResult());
        this.iamOperations.detachAllPoliciesFromRole("test-role-1");
        ((AmazonIdentityManagement)Mockito.verify((Object)this.amazonIdentityManagement)).detachRolePolicy(new DetachRolePolicyRequest().withPolicyArn(this.prefixed("test-policy-1")).withRoleName("test-role-1"));
        ((AmazonIdentityManagement)Mockito.verify((Object)this.amazonIdentityManagement)).detachRolePolicy(new DetachRolePolicyRequest().withPolicyArn(this.prefixed("test-policy-2")).withRoleName("test-role-1"));
    }

    private void givenPolicies(String ... names) {
        for (String name : names) {
            Mockito.when((Object)this.iamDiscovery.getPolicyArn(name)).thenReturn(Optional.of(this.prefixed(name)));
        }
    }

    private void givenNoPolicies() {
        Mockito.when((Object)this.iamDiscovery.getPolicyArn((String)ArgumentMatchers.any())).thenReturn(Optional.empty());
    }

    private void givenExceptionThrownDuringInstanceProfileCreation(Exception e) {
        Mockito.when((Object)this.amazonIdentityManagement.createInstanceProfile((CreateInstanceProfileRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
    }

    private void givenExceptionThrownDuringRoleCreation(Exception e) {
        Mockito.when((Object)this.amazonIdentityManagement.createRole((CreateRoleRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
    }

    private void givenSuccessfulInstanceProfileCreation(String name) {
        CreateInstanceProfileResult createInstanceProfileResult = this.getSuccessfulCreateInstanceProfileResult(name);
        Mockito.when((Object)this.amazonIdentityManagement.createInstanceProfile((CreateInstanceProfileRequest)ArgumentMatchers.any())).thenReturn((Object)createInstanceProfileResult);
    }

    private void givenSuccessfulRoleCreation(String roleName) {
        CreateRoleResult createRoleResult = this.getSuccessfulCreateRoleResult(roleName);
        Mockito.when((Object)this.amazonIdentityManagement.createRole((CreateRoleRequest)ArgumentMatchers.any())).thenReturn((Object)createRoleResult);
    }

    private void givenExceptionThrownWhenAddingRoleToInstanceProfile(Exception e) {
        Mockito.when((Object)this.amazonIdentityManagement.addRoleToInstanceProfile((AddRoleToInstanceProfileRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
    }

    private void givenSuccessfulAdditionOfRoleToPolicy() {
        Mockito.when((Object)this.amazonIdentityManagement.addRoleToInstanceProfile((AddRoleToInstanceProfileRequest)ArgumentMatchers.any())).thenReturn((Object)new AddRoleToInstanceProfileResult());
    }

    private void givenExceptionThrownWhenAttachingPolicy(Exception e) {
        Mockito.when((Object)this.amazonIdentityManagement.attachRolePolicy((AttachRolePolicyRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
    }

    private void givenSuccessfulAttachmentOfAPolicy() {
        Mockito.when((Object)this.amazonIdentityManagement.attachRolePolicy((AttachRolePolicyRequest)ArgumentMatchers.any())).thenReturn((Object)new AttachRolePolicyResult());
    }

    private CreateInstanceProfileResult getSuccessfulCreateInstanceProfileResult(String name) {
        return new CreateInstanceProfileResult().withInstanceProfile(this.instanceProfileWithName(name));
    }

    private CreateRoleResult getSuccessfulCreateRoleResult(String name) {
        return new CreateRoleResult().withRole(this.roleWithArn(name));
    }

    private InstanceProfile instanceProfileWithName(String name) {
        return new InstanceProfile().withInstanceProfileName(name);
    }

    private Role roleWithArn(String name) {
        return new Role().withRoleName(name);
    }

    private String prefixed(String policyName) {
        return "arn:aws:iam::123456789012:" + policyName;
    }

    private OngoingStubbing<DetachRolePolicyResult> whenDetachRolePolicyRequested(String policy, String role) {
        return Mockito.when((Object)this.amazonIdentityManagement.detachRolePolicy(new DetachRolePolicyRequest().withRoleName(role).withPolicyArn(this.prefixed(policy))));
    }

    private DetachRolePolicyResult someDetachRolePolicyResult() {
        return new DetachRolePolicyResult();
    }

    private OngoingStubbing<DeleteInstanceProfileResult> whenDeleteInstanceProfileRequested() {
        return Mockito.when((Object)this.amazonIdentityManagement.deleteInstanceProfile(new DeleteInstanceProfileRequest().withInstanceProfileName("test-profile")));
    }

    private DeleteInstanceProfileResult someDeleteInstanceProfileResult() {
        return new DeleteInstanceProfileResult();
    }

    private OngoingStubbing<DeleteRoleResult> whenDeleteRoleRequested() {
        return Mockito.when((Object)this.amazonIdentityManagement.deleteRole(new DeleteRoleRequest().withRoleName("test-role-1")));
    }

    private DeleteRoleResult someDeleteRoleResult() {
        return new DeleteRoleResult();
    }

    private OngoingStubbing<RemoveRoleFromInstanceProfileResult> whenRemoveRoleFromInstanceProfileRequested(String role) {
        return Mockito.when((Object)this.amazonIdentityManagement.removeRoleFromInstanceProfile(new RemoveRoleFromInstanceProfileRequest().withRoleName(role).withInstanceProfileName("test-profile")));
    }

    private RemoveRoleFromInstanceProfileResult someRemoveRoleFromInstanceProfileResult() {
        return new RemoveRoleFromInstanceProfileResult();
    }
}

