/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.AmazonElasticLoadBalancingException;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import com.amazonaws.services.elasticloadbalancing.model.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsElasticLoadBalancer;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsLoadBalancerHealthCheckParameters;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsLoadBalancerListener;
import pl.codewise.commons.aws.cqrs.model.ec2.LoadBalancerParameters;
import pl.codewise.commons.aws.cqrs.operations.ClassicLoadBalancingOperations;

@RunWith(value=MockitoJUnitRunner.class)
public class ClassicLoadBalancingOperationsTest {
    private final String name = "test-elb";
    private final List<Listener> listeners = Collections.singletonList(new Listener("HTTP", Integer.valueOf(80), Integer.valueOf(80)));
    private final List<AwsLoadBalancerListener> awsLoadBalancerListeners = Collections.singletonList(new AwsLoadBalancerListener("HTTP", 80, 80, null));
    private final List<String> subnets = Arrays.asList("subnet-01234567", "subnet-12345678");
    private final List<String> securityGroups = Arrays.asList("sg-23456789", "sg-34567890");
    private final LoadBalancerParameters publicLoadBalancerParameters = this.preconfiguredLoadBalancerParametersBuilder().withInternal(false).build();
    private final LoadBalancerParameters privateLoadBalancerParameters = this.preconfiguredLoadBalancerParametersBuilder().withInternal(true).build();
    private final Pair<AwsLoadBalancerHealthCheckParameters, HealthCheck> healthCheckMapping = this.prepareHealthCheckMapping();
    @Mock
    private AmazonElasticLoadBalancing amazonElasticLoadBalancing;
    @InjectMocks
    private ClassicLoadBalancingOperations operations;

    @Test
    public void shouldNotReturnLoadBalancerWhenExceptionThrownDuringCreation() {
        this.givenExceptionThrownDuringLoadBalancerCreation((Exception)new AmazonElasticLoadBalancingException("UnableToCreate"));
        Throwable throwable = Assertions.catchThrowable(() -> this.operations.createLoadBalancer(this.publicLoadBalancerParameters));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonElasticLoadBalancingException.class)).hasMessageContaining("UnableToCreate");
    }

    @Test
    public void shouldAttemptToCreatePublicLoadBalancerWhenIsPrivateParameterIsFalse() {
        this.givenLoadBalancerCreationRequested();
        this.operations.createLoadBalancer(this.publicLoadBalancerParameters);
        this.assertPublicLoadBalancerRequested();
    }

    @Test
    public void shouldAttemptToCreatePrivateLoadBalancerWhenIsPrivateParameterIsTrue() {
        this.givenLoadBalancerCreationRequested();
        this.operations.createLoadBalancer(this.privateLoadBalancerParameters);
        this.assertPrivateLoadBalancerRequested();
    }

    @Test
    public void shouldReturnCreatedLoadBalancerWhenSuccessful() {
        AwsElasticLoadBalancer loadBalancer = this.operations.createLoadBalancer(this.publicLoadBalancerParameters);
        Assertions.assertThat((Object)loadBalancer).isEqualTo((Object)new AwsElasticLoadBalancer("test-elb"));
        ((AmazonElasticLoadBalancing)Mockito.verify((Object)this.amazonElasticLoadBalancing)).createLoadBalancer((CreateLoadBalancerRequest)ArgumentMatchers.argThat(request -> StringUtils.equalsIgnoreCase((CharSequence)request.getLoadBalancerName(), (CharSequence)"test-elb")));
    }

    @Test
    public void shouldFailDeletingLoadBalancer() {
        this.whenDeleteLoadBalancerRequested("test-elb").thenThrow(new Throwable[]{new AmazonElasticLoadBalancingException("UnableToDeleteLoadBalancer")});
        Throwable throwable = Assertions.catchThrowable(() -> this.operations.deleteLoadBalancer("test-elb"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonElasticLoadBalancingException.class)).hasMessageContaining("UnableToDeleteLoadBalancer");
    }

    @Test
    public void shouldDeleteLoadBalancer() {
        this.operations.deleteLoadBalancer("test-elb");
        ((AmazonElasticLoadBalancing)Mockito.verify((Object)this.amazonElasticLoadBalancing)).deleteLoadBalancer(new DeleteLoadBalancerRequest("test-elb"));
    }

    @Test
    public void shouldReturnFalseWhenExceptionThrownDuringHealthCheckConfiguration() {
        this.givenExceptionThrownDuringHealthCheckConfiguration((Exception)new AmazonElasticLoadBalancingException("UnableToConfigureHealthCheck"));
        Throwable throwable = Assertions.catchThrowable(() -> this.operations.configureHealthCheckForLoadBalancer("test-elb", (AwsLoadBalancerHealthCheckParameters)this.healthCheckMapping.getKey()));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonElasticLoadBalancingException.class)).hasMessageContaining("UnableToConfigureHealthCheck");
    }

    @Test
    public void shouldReturnTrueWhenSuccessfullyConfiguredHealthCheck() {
        this.operations.configureHealthCheckForLoadBalancer("test-elb", (AwsLoadBalancerHealthCheckParameters)this.healthCheckMapping.getKey());
        ((AmazonElasticLoadBalancing)Mockito.verify((Object)this.amazonElasticLoadBalancing)).configureHealthCheck(new ConfigureHealthCheckRequest("test-elb", (HealthCheck)this.healthCheckMapping.getValue()));
    }

    private void givenExceptionThrownDuringLoadBalancerCreation(Exception e) {
        Mockito.when((Object)this.amazonElasticLoadBalancing.createLoadBalancer((CreateLoadBalancerRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
    }

    private void givenLoadBalancerCreationRequested() {
        Mockito.when((Object)this.amazonElasticLoadBalancing.createLoadBalancer((CreateLoadBalancerRequest)ArgumentMatchers.any())).thenReturn((Object)new CreateLoadBalancerResult());
    }

    private void assertPublicLoadBalancerRequested() {
        this.assertRequestedWithScheme(null);
    }

    private void assertPrivateLoadBalancerRequested() {
        this.assertRequestedWithScheme("internal");
    }

    private void assertRequestedWithScheme(String scheme) {
        ((AmazonElasticLoadBalancing)Mockito.verify((Object)this.amazonElasticLoadBalancing, (VerificationMode)Mockito.times((int)1))).createLoadBalancer(new CreateLoadBalancerRequest().withLoadBalancerName("test-elb").withListeners(this.listeners).withSubnets(this.subnets).withSecurityGroups(this.securityGroups).withScheme(scheme).withTags(new Tag[]{new Tag().withKey("Name").withValue("test-elb")}));
    }

    private OngoingStubbing<DeleteLoadBalancerResult> whenDeleteLoadBalancerRequested(String loadBalancerName) {
        return Mockito.when((Object)this.amazonElasticLoadBalancing.deleteLoadBalancer(new DeleteLoadBalancerRequest(loadBalancerName)));
    }

    private void givenExceptionThrownDuringHealthCheckConfiguration(Exception e) {
        Mockito.when((Object)this.amazonElasticLoadBalancing.configureHealthCheck((ConfigureHealthCheckRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
    }

    private void givenSuccessfulHealthCheckConfiguration() {
        Mockito.when((Object)this.amazonElasticLoadBalancing.configureHealthCheck((ConfigureHealthCheckRequest)ArgumentMatchers.any())).thenReturn((Object)new ConfigureHealthCheckResult());
    }

    private LoadBalancerParameters.Builder preconfiguredLoadBalancerParametersBuilder() {
        return LoadBalancerParameters.builder().withName("test-elb").withListeners(this.awsLoadBalancerListeners).withSubnets(this.subnets).withSecurityGroups(this.securityGroups);
    }

    private Pair<AwsLoadBalancerHealthCheckParameters, HealthCheck> prepareHealthCheckMapping() {
        String target = "HTTP:80/";
        int timeout = 5;
        int interval = 30;
        int unhealthyThreshold = 1;
        int healthyThreshold = 2;
        HealthCheck healthCheck = new HealthCheck().withTarget(target).withTimeout(Integer.valueOf(timeout)).withInterval(Integer.valueOf(interval)).withUnhealthyThreshold(Integer.valueOf(unhealthyThreshold)).withHealthyThreshold(Integer.valueOf(healthyThreshold));
        AwsLoadBalancerHealthCheckParameters parameters = AwsLoadBalancerHealthCheckParameters.builder().withTarget(target).withTimeout(timeout).withInterval(interval).withUnhealthyThreshold(unhealthyThreshold).withHealthyThreshold(healthyThreshold).build();
        return Pair.of((Object)parameters, (Object)healthCheck);
    }
}

