/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.Alarm;
import com.amazonaws.services.autoscaling.model.AmazonAutoScalingException;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest;
import com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupResult;
import com.amazonaws.services.autoscaling.model.DeleteTagsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DetachLoadBalancersRequest;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest;
import com.amazonaws.services.autoscaling.model.PutScalingPolicyResult;
import com.amazonaws.services.autoscaling.model.ScalingPolicy;
import com.amazonaws.services.autoscaling.model.SetInstanceProtectionRequest;
import com.amazonaws.services.autoscaling.model.StepAdjustment;
import com.amazonaws.services.autoscaling.model.Tag;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricAlarm;
import com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import pl.codewise.commons.aws.cqrs.discovery.AutoScalingDiscovery;
import pl.codewise.commons.aws.cqrs.discovery.ClassicLoadBalancingDiscovery;
import pl.codewise.commons.aws.cqrs.model.AwsAutoScalingGroup;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;
import pl.codewise.commons.aws.cqrs.model.AwsScalingPolicies;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsAutoScalingTag;
import pl.codewise.commons.aws.cqrs.operations.AutoScalingOperations;
import pl.codewise.commons.aws.cqrs.utils.Awaitilities;

@RunWith(value=MockitoJUnitRunner.class)
public class AutoScalingOperationsTest {
    private static final String REGION_A = "REGION-A";
    private static final String ASG_NAME = "ASG_name";
    private static final AwsAutoScalingGroup ASG = new AwsAutoScalingGroup.Builder().withAutoScalingGroupName("name").withLaunchConfigurationName("lc-name").withMinSize(Integer.valueOf(11)).withMaxSize(Integer.valueOf(13)).withDesiredCapacity(Integer.valueOf(12)).withDefaultCooldown(Integer.valueOf(10)).withAvailabilityZones(Arrays.asList("AZ-1", "AZ-2")).withLoadBalancerNames(Arrays.asList("LB-1", "LB-2")).withHealthCheckType("HC-type-1").withHealthCheckGracePeriod(Integer.valueOf(100)).withPlacementGroup("PG").withVpcZoneIdentifier("VPC-1").withNewInstancesProtectedFromScaleIn(Boolean.valueOf(true)).withTags(Arrays.asList(new AwsAutoScalingTag("rid", "tk-1", "tk-1", Boolean.valueOf(true)), new AwsAutoScalingTag("rid", "tk-2", "tv-2", Boolean.valueOf(true)))).withTerminationPolicies(Collections.singletonList("Termination-policy")).build();
    private static final ScalingPolicy SCALING_POLICY_1 = new ScalingPolicy().withAutoScalingGroupName("ASG_name").withPolicyName("Policy 1").withPolicyType("Policy type 1").withCooldown(Integer.valueOf(10)).withEstimatedInstanceWarmup(Integer.valueOf(20)).withMetricAggregationType("mat").withAdjustmentType("at").withMinAdjustmentMagnitude(Integer.valueOf(10)).withMinAdjustmentStep(Integer.valueOf(20)).withScalingAdjustment(Integer.valueOf(15)).withAlarms(new Alarm[]{new Alarm().withAlarmName("Scaling Alarm 1")}).withStepAdjustments(new StepAdjustment[]{new StepAdjustment().withMetricIntervalLowerBound(Double.valueOf(2.0)).withMetricIntervalUpperBound(Double.valueOf(3.0)).withScalingAdjustment(Integer.valueOf(400)), new StepAdjustment().withMetricIntervalLowerBound(Double.valueOf(1.0)).withMetricIntervalUpperBound(Double.valueOf(2.0)).withScalingAdjustment(Integer.valueOf(500))});
    private static final ScalingPolicy SCALING_POLICY_2 = new ScalingPolicy().withAutoScalingGroupName("ASG_name").withPolicyName("Policy 2").withPolicyType("Policy type 2").withCooldown(Integer.valueOf(30)).withEstimatedInstanceWarmup(Integer.valueOf(10)).withMetricAggregationType("mat 2").withAdjustmentType("at 2").withMinAdjustmentMagnitude(Integer.valueOf(30)).withMinAdjustmentStep(Integer.valueOf(10)).withScalingAdjustment(Integer.valueOf(11)).withAlarms(new Alarm[]{new Alarm().withAlarmName("Scaling Alarm 2")}).withStepAdjustments(new StepAdjustment[]{new StepAdjustment().withMetricIntervalLowerBound(Double.valueOf(2.0)).withMetricIntervalUpperBound(Double.valueOf(3.0)).withScalingAdjustment(Integer.valueOf(400)), new StepAdjustment().withMetricIntervalLowerBound(Double.valueOf(1.0)).withMetricIntervalUpperBound(Double.valueOf(2.0)).withScalingAdjustment(Integer.valueOf(500))});
    private AutoScalingOperations autoScalingOperations;
    @Mock
    private AmazonAutoScaling autoScaling;
    @Mock
    private AmazonCloudWatch cloudWatch;
    @Mock
    private AutoScalingDiscovery asgDiscovery;
    @Mock
    private ClassicLoadBalancingDiscovery elbDiscovery;
    private Awaitilities awaitilities = new Awaitilities();

    @Before
    public void setUp() {
        this.autoScalingOperations = new AutoScalingOperations(REGION_A, this.autoScaling, this.cloudWatch, this.asgDiscovery, this.elbDiscovery, this.awaitilities, 1000L, 1000L, 1000L, 100L);
    }

    @Test
    public void shouldCopyAndOverride() {
        String newAsgName = "newASG_name";
        AwsAutoScalingGroup newAsgMeta = new AwsAutoScalingGroup.Builder().withAutoScalingGroupName(newAsgName).withAvailabilityZones(Arrays.asList("AZ-3", "AZ-4")).withDesiredCapacity(Integer.valueOf(1)).withMinSize(Integer.valueOf(2)).withMaxSize(Integer.valueOf(3)).withHealthCheckGracePeriod(Integer.valueOf(300)).withNewInstancesProtectedFromScaleIn(Boolean.valueOf(false)).withTags(Arrays.asList(new AwsAutoScalingTag("rid", "tk-3", "tv-3", Boolean.valueOf(true)), new AwsAutoScalingTag("rid", "tk-4", "tv-4", Boolean.valueOf(true)))).build();
        CreateAutoScalingGroupRequest expectedAsgRequest = new CreateAutoScalingGroupRequest().withAutoScalingGroupName(newAsgMeta.getAutoScalingGroupName()).withMinSize(newAsgMeta.getMinSize()).withMaxSize(newAsgMeta.getMaxSize()).withDesiredCapacity(newAsgMeta.getDesiredCapacity()).withLaunchConfigurationName("lc-name").withDefaultCooldown(Integer.valueOf(10)).withAvailabilityZones(new String[]{"AZ-3", "AZ-4"}).withLoadBalancerNames(new String[]{"LB-1", "LB-2"}).withHealthCheckType("HC-type-1").withHealthCheckGracePeriod(Integer.valueOf(300)).withPlacementGroup("PG").withVPCZoneIdentifier("VPC-1").withNewInstancesProtectedFromScaleIn(Boolean.valueOf(false)).withTags(new Tag[]{new Tag().withResourceId("newASG_name").withKey("tk-3").withValue("tv-3").withPropagateAtLaunch(Boolean.valueOf(true)).withResourceType("auto-scaling-group"), new Tag().withResourceId("newASG_name").withKey("tk-4").withValue("tv-4").withPropagateAtLaunch(Boolean.valueOf(true)).withResourceType("auto-scaling-group")}).withTerminationPolicies(new String[]{"Termination-policy"});
        AwsAutoScalingGroup actualCopiedASG = new AwsAutoScalingGroup.Builder().withAutoScalingGroupName(newAsgName).withAwsInstances(null).withLoadBalancerNames(null).withDesiredCapacity(Integer.valueOf(10)).withMinSize(Integer.valueOf(10)).withMaxSize(Integer.valueOf(10)).withCreated(null).build();
        Mockito.when((Object)this.asgDiscovery.getAutoScalingGroupByName(ASG_NAME)).thenReturn((Object)ASG);
        Mockito.when((Object)this.asgDiscovery.getAutoScalingGroupByName(newAsgName)).thenReturn((Object)actualCopiedASG);
        AwsAutoScalingGroup copiedASG = this.autoScalingOperations.copy(ASG_NAME, newAsgMeta);
        Assertions.assertThat((Object)copiedASG).isSameAs((Object)actualCopiedASG);
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).createAutoScalingGroup(expectedAsgRequest);
    }

    @Test
    public void shouldCopyScalingPoliciesWithAlarms() {
        String sourceGroupName = "sourceAutoScalingGroup";
        String targetGroupName = "targetAutoScalingGroup";
        String scalingAlarmOne = "Scaling Alarm 1";
        String scalingAlarmTwo = "Scaling Alarm 2";
        AwsScalingPolicies awsScalingPolicies = new AwsScalingPolicies();
        awsScalingPolicies.addPolicy(SCALING_POLICY_1);
        awsScalingPolicies.addPolicy(SCALING_POLICY_2);
        Mockito.when((Object)this.asgDiscovery.getScalingPolicies(sourceGroupName)).thenReturn((Object)awsScalingPolicies);
        Mockito.when((Object)this.autoScaling.putScalingPolicy(this.scalingPolicyOne(targetGroupName))).thenReturn((Object)this.scalingPolicyResult("Policy ARN 1"));
        Mockito.when((Object)this.autoScaling.putScalingPolicy(this.scalingPolicyTwo(targetGroupName))).thenReturn((Object)this.scalingPolicyResult("Policy ARN 2"));
        Mockito.when((Object)this.cloudWatch.describeAlarms(this.describeAlarmsRequest(scalingAlarmOne))).thenReturn((Object)this.describeAlarmsResult(scalingAlarmOne));
        Mockito.when((Object)this.cloudWatch.describeAlarms(this.describeAlarmsRequest(scalingAlarmTwo))).thenReturn((Object)this.describeAlarmsResult(scalingAlarmTwo));
        this.autoScalingOperations.copyScalingPolicies(sourceGroupName, targetGroupName, " NewSuffix");
        ((AutoScalingDiscovery)Mockito.verify((Object)this.asgDiscovery)).getScalingPolicies(sourceGroupName);
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).putScalingPolicy(this.scalingPolicyOne(targetGroupName));
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).putScalingPolicy(this.scalingPolicyTwo(targetGroupName));
        ((AmazonCloudWatch)Mockito.verify((Object)this.cloudWatch)).describeAlarms(this.describeAlarmsRequest(scalingAlarmOne));
        ((AmazonCloudWatch)Mockito.verify((Object)this.cloudWatch)).describeAlarms(this.describeAlarmsRequest(scalingAlarmTwo));
        ((AmazonCloudWatch)Mockito.verify((Object)this.cloudWatch)).putMetricAlarm(this.putMetricAlarmRequestOne());
        ((AmazonCloudWatch)Mockito.verify((Object)this.cloudWatch)).putMetricAlarm(this.putMetricAlarmRequestTwo());
    }

    @Test
    public void shouldDetachELB() {
        Mockito.when((Object)this.asgDiscovery.getAutoScalingGroupByName(ASG_NAME)).thenReturn((Object)ASG);
        DetachLoadBalancersRequest expectedRequest = new DetachLoadBalancersRequest().withAutoScalingGroupName(ASG_NAME).withLoadBalancerNames((Collection)ASG.getLoadBalancerNames());
        this.autoScalingOperations.detachLoadBalancers(ASG_NAME);
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).detachLoadBalancers(expectedRequest);
    }

    @Test
    public void shouldSkipNoELBToDetach() {
        AwsAutoScalingGroup asgWithoutELBs = new AwsAutoScalingGroup.Builder().withAutoScalingGroupName("name").withLaunchConfigurationName("lc-name").build();
        Mockito.when((Object)this.asgDiscovery.getAutoScalingGroupByName(ASG_NAME)).thenReturn((Object)asgWithoutELBs);
        this.autoScalingOperations.detachLoadBalancers(ASG_NAME);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.autoScaling});
    }

    @Test
    public void shouldChangeScalingSizes() {
        UpdateAutoScalingGroupRequest expectedUpdateRequest = new UpdateAutoScalingGroupRequest().withAutoScalingGroupName(ASG_NAME).withMinSize(Integer.valueOf(4)).withDesiredCapacity(Integer.valueOf(5)).withMaxSize(Integer.valueOf(6));
        this.autoScalingOperations.setSizes(ASG_NAME, 4, 5, 6);
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).updateAutoScalingGroup(expectedUpdateRequest);
    }

    @Test
    public void shouldRemoveAsg() {
        UpdateAutoScalingGroupRequest expectedUpdateRequest = new UpdateAutoScalingGroupRequest().withAutoScalingGroupName(ASG_NAME).withMinSize(Integer.valueOf(0)).withDesiredCapacity(Integer.valueOf(0)).withMaxSize(Integer.valueOf(0));
        DeleteAutoScalingGroupRequest expectedDeleteRequest = new DeleteAutoScalingGroupRequest().withAutoScalingGroupName(ASG_NAME);
        DescribeAutoScalingGroupsRequest descAsgRequest = new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{ASG_NAME});
        Mockito.when((Object)this.asgDiscovery.getAutoScalingGroupRaw(ASG_NAME)).thenReturn((Object)new AutoScalingGroup().withAutoScalingGroupName(ASG_NAME).withInstances(new Instance[]{new Instance()})).thenReturn((Object)new AutoScalingGroup().withAutoScalingGroupName(ASG_NAME).withInstances(Collections.emptyList()));
        Mockito.when((Object)this.autoScaling.describeAutoScalingGroups(descAsgRequest)).thenReturn((Object)new DescribeAutoScalingGroupsResult().withAutoScalingGroups(new AutoScalingGroup[]{new AutoScalingGroup().withStatus("Delete in progress"), new AutoScalingGroup().withStatus("Running")})).thenReturn((Object)new DescribeAutoScalingGroupsResult().withAutoScalingGroups(new AutoScalingGroup[]{new AutoScalingGroup().withStatus("Delete in progress")}));
        this.autoScalingOperations.removeAutoScalingGroup(ASG_NAME);
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).updateAutoScalingGroup(expectedUpdateRequest);
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).deleteAutoScalingGroup(expectedDeleteRequest);
    }

    @Test
    public void shouldWaitForAsgSizeToChange() {
        String targetAsgName = "TARGET";
        int desiredCapacity = 4;
        AwsAutoScalingGroup validAsgResponse = this.prepareAsgDataResponse(targetAsgName, desiredCapacity);
        Mockito.when((Object)this.asgDiscovery.getAutoScalingGroupByName(targetAsgName)).thenReturn((Object)this.prepareAsgDataResponse(targetAsgName, 0)).thenReturn((Object)this.prepareAsgDataResponse(targetAsgName, desiredCapacity - 1)).thenReturn((Object)validAsgResponse);
        Mockito.when((Object)this.elbDiscovery.areInstancesInService("ELB", validAsgResponse.getAwsInstances())).thenReturn((Object)false).thenReturn((Object)true);
        Mockito.when((Object)this.elbDiscovery.areInstancesInService("ELB1", validAsgResponse.getAwsInstances())).thenReturn((Object)false).thenReturn((Object)true);
        this.autoScalingOperations.waitForAsgToChangeSize(targetAsgName, desiredCapacity);
        ((AutoScalingDiscovery)Mockito.verify((Object)this.asgDiscovery, (VerificationMode)Mockito.times((int)5))).getAutoScalingGroupByName(targetAsgName);
        ((ClassicLoadBalancingDiscovery)Mockito.verify((Object)this.elbDiscovery, (VerificationMode)Mockito.times((int)3))).areInstancesInService("ELB", validAsgResponse.getAwsInstances());
        ((ClassicLoadBalancingDiscovery)Mockito.verify((Object)this.elbDiscovery, (VerificationMode)Mockito.times((int)2))).areInstancesInService("ELB1", validAsgResponse.getAwsInstances());
    }

    @Test
    public void shouldFailToCreateAutoScalingGroup() {
        Mockito.when((Object)this.autoScaling.createAutoScalingGroup((CreateAutoScalingGroupRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{new AmazonAutoScalingException("UnableToCreate")});
        AwsAutoScalingGroup someTemplate = new AwsAutoScalingGroup.Builder().build();
        Throwable throwable = Assertions.catchThrowable(() -> this.autoScalingOperations.create(someTemplate));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonAutoScalingException.class)).hasMessageContaining("UnableToCreate");
    }

    @Test
    public void shouldFailWhenUnableToFetchJustCreatedAutoScalingGroup() {
        String autoScalingGroupName = "test-asg";
        Mockito.when((Object)this.asgDiscovery.getAutoScalingGroupByName(autoScalingGroupName)).thenReturn(null);
        AwsAutoScalingGroup someTemplate = new AwsAutoScalingGroup.Builder().withAutoScalingGroupName(autoScalingGroupName).build();
        AwsAutoScalingGroup autoScalingGroup = this.autoScalingOperations.create(someTemplate);
        Assertions.assertThat((Object)autoScalingGroup).isNull();
    }

    @Test
    public void shouldCreateAutoScalingGroup() {
        AwsAutoScalingGroup someTemplate = new AwsAutoScalingGroup.Builder().withAutoScalingGroupName(ASG_NAME).build();
        Mockito.when((Object)this.asgDiscovery.getAutoScalingGroupByName(someTemplate.getAutoScalingGroupName())).thenReturn((Object)someTemplate);
        AwsAutoScalingGroup autoScalingGroup = this.autoScalingOperations.create(someTemplate);
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).createAutoScalingGroup(new CreateAutoScalingGroupRequest().withAutoScalingGroupName(someTemplate.getAutoScalingGroupName()));
        Assertions.assertThat((Object)autoScalingGroup).isEqualTo((Object)someTemplate);
    }

    @Test
    public void shouldFailToForcefullyDeleteAutoScalingGroup() {
        this.whenForcefulDeleteRequested(ASG_NAME).thenThrow(new Throwable[]{new AmazonAutoScalingException("UnableToDeleteAutoScalingGroup")});
        Throwable throwable = Assertions.catchThrowable(() -> this.autoScalingOperations.deleteForcefully(ASG_NAME));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(AmazonAutoScalingException.class)).hasMessageContaining("UnableToDeleteAutoScalingGroup");
    }

    @Test
    public void shouldForcefullyDeleteAutoScalingGroup() {
        this.whenForcefulDeleteRequested(ASG_NAME).thenReturn((Object)new DeleteAutoScalingGroupResult());
        this.autoScalingOperations.deleteForcefully(ASG_NAME);
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).deleteAutoScalingGroup(new DeleteAutoScalingGroupRequest().withAutoScalingGroupName(ASG_NAME).withForceDelete(Boolean.valueOf(true)));
    }

    @Test
    public void shouldUpdateTerminationPolicies() {
        UpdateAutoScalingGroupRequest expectedUpdateRequest = new UpdateAutoScalingGroupRequest().withAutoScalingGroupName(ASG_NAME).withTerminationPolicies(Collections.singletonList("Default"));
        this.autoScalingOperations.setTerminationPolicies(ASG_NAME, Collections.singletonList("Default"));
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).updateAutoScalingGroup(expectedUpdateRequest);
    }

    @Test
    public void shouldCreateOrUpdateTag() {
        AwsAutoScalingTag tag = this.aTag();
        this.autoScalingOperations.createOrUpdateTag(tag);
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).createOrUpdateTags(new CreateOrUpdateTagsRequest().withTags(new Tag[]{this.anExpectedTag()}));
    }

    @Test
    public void shouldCreateOrUpdateTags() {
        AwsAutoScalingTag tag1 = this.aTag();
        AwsAutoScalingTag tag2 = this.aTag();
        this.autoScalingOperations.createOrUpdateTags(Arrays.asList(tag1, tag2));
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).createOrUpdateTags(new CreateOrUpdateTagsRequest().withTags(new Tag[]{this.anExpectedTag(), this.anExpectedTag()}));
    }

    @Test
    public void shouldDeleteTag() {
        AwsAutoScalingTag tag = this.aTag();
        this.autoScalingOperations.deleteTag(tag);
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).deleteTags(new DeleteTagsRequest().withTags(new Tag[]{this.anExpectedTag()}));
    }

    @Test
    public void shouldSetScaleInProtection() {
        this.autoScalingOperations.setScaleInProtection("group-name", "i-1111", true);
        ((AmazonAutoScaling)Mockito.verify((Object)this.autoScaling)).setInstanceProtection(new SetInstanceProtectionRequest().withInstanceIds(new String[]{"i-1111"}).withAutoScalingGroupName("group-name").withProtectedFromScaleIn(Boolean.valueOf(true)));
    }

    private AwsAutoScalingTag aTag() {
        return new AwsAutoScalingTag("group-name", "some-key", "some-value", Boolean.valueOf(false));
    }

    private Tag anExpectedTag() {
        return new Tag().withResourceId("group-name").withResourceType("auto-scaling-group").withKey("some-key").withValue("some-value").withPropagateAtLaunch(Boolean.valueOf(false));
    }

    private AwsAutoScalingGroup prepareAsgDataResponse(String name, int desiredCapacity) {
        return new AwsAutoScalingGroup.Builder().withAutoScalingGroupName(name).withAwsInstances(this.prepareAwsInstances(desiredCapacity)).withLoadBalancerNames(Arrays.asList("ELB", "ELB1")).withDesiredCapacity(Integer.valueOf(desiredCapacity)).withMinSize(Integer.valueOf(0)).withMaxSize(Integer.valueOf(0)).withCreated(null).build();
    }

    private List<AwsInstance> prepareAwsInstances(int count) {
        return IntStream.range(0, count).mapToObj(i -> new AwsInstance.Builder().withInstanceId("DNS" + i).withPublicDnsName("DNS 1").withPrivateIpAddress("IP").withPublicIpAddress("PUBLIC-IP").withIamInstanceProfileArn("").withImageId("ami-abc123").withRegion(REGION_A).withState("running").build()).collect(Collectors.toList());
    }

    private OngoingStubbing<DeleteAutoScalingGroupResult> whenForcefulDeleteRequested(String autoScalingGroupName) {
        return Mockito.when((Object)this.autoScaling.deleteAutoScalingGroup(new DeleteAutoScalingGroupRequest().withAutoScalingGroupName(autoScalingGroupName).withForceDelete(Boolean.valueOf(true))));
    }

    private PutScalingPolicyRequest scalingPolicyOne(String targetGroupName) {
        return new PutScalingPolicyRequest().withAutoScalingGroupName(targetGroupName).withPolicyName("Policy 1").withPolicyType("Policy type 1").withCooldown(Integer.valueOf(10)).withEstimatedInstanceWarmup(Integer.valueOf(20)).withMetricAggregationType("mat").withAdjustmentType("at").withMinAdjustmentMagnitude(Integer.valueOf(10)).withMinAdjustmentStep(Integer.valueOf(20)).withScalingAdjustment(Integer.valueOf(15)).withStepAdjustments(new StepAdjustment[]{new StepAdjustment().withMetricIntervalLowerBound(Double.valueOf(2.0)).withMetricIntervalUpperBound(Double.valueOf(3.0)).withScalingAdjustment(Integer.valueOf(400)), new StepAdjustment().withMetricIntervalLowerBound(Double.valueOf(1.0)).withMetricIntervalUpperBound(Double.valueOf(2.0)).withScalingAdjustment(Integer.valueOf(500))});
    }

    private PutScalingPolicyRequest scalingPolicyTwo(String targetGroupName) {
        return new PutScalingPolicyRequest().withAutoScalingGroupName(targetGroupName).withPolicyName("Policy 2").withPolicyType("Policy type 2").withCooldown(Integer.valueOf(30)).withEstimatedInstanceWarmup(Integer.valueOf(10)).withMetricAggregationType("mat 2").withAdjustmentType("at 2").withMinAdjustmentMagnitude(Integer.valueOf(30)).withMinAdjustmentStep(Integer.valueOf(10)).withScalingAdjustment(Integer.valueOf(11)).withStepAdjustments(new StepAdjustment[]{new StepAdjustment().withMetricIntervalLowerBound(Double.valueOf(2.0)).withMetricIntervalUpperBound(Double.valueOf(3.0)).withScalingAdjustment(Integer.valueOf(400)), new StepAdjustment().withMetricIntervalLowerBound(Double.valueOf(1.0)).withMetricIntervalUpperBound(Double.valueOf(2.0)).withScalingAdjustment(Integer.valueOf(500))});
    }

    private PutScalingPolicyResult scalingPolicyResult(String policyARN) {
        return new PutScalingPolicyResult().withPolicyARN(policyARN);
    }

    private DescribeAlarmsRequest describeAlarmsRequest(String alarmName) {
        return new DescribeAlarmsRequest().withAlarmNames(new String[]{alarmName});
    }

    private DescribeAlarmsResult describeAlarmsResult(String alarmName) {
        return new DescribeAlarmsResult().withMetricAlarms(new MetricAlarm[]{new MetricAlarm().withAlarmName(alarmName).withStatistic("CPUUtilization").withDimensions(new Dimension[]{new Dimension().withName("AutoScalingGroupName").withValue("sourceAutoScalingGroup"), new Dimension().withName("TopicName").withValue("sourceTopicName")}).withThreshold(Double.valueOf(50.0))});
    }

    private PutMetricAlarmRequest putMetricAlarmRequestOne() {
        return new PutMetricAlarmRequest().withAlarmName("Scaling Alarm 1 NewSuffix").withAlarmActions(new String[]{"Policy ARN 1"}).withStatistic("CPUUtilization").withDimensions(new Dimension[]{new Dimension().withName("AutoScalingGroupName").withValue("targetAutoScalingGroup"), new Dimension().withName("TopicName").withValue("sourceTopicName")}).withThreshold(Double.valueOf(50.0));
    }

    private PutMetricAlarmRequest putMetricAlarmRequestTwo() {
        return new PutMetricAlarmRequest().withAlarmName("Scaling Alarm 2 NewSuffix").withAlarmActions(new String[]{"Policy ARN 2"}).withStatistic("CPUUtilization").withDimensions(new Dimension[]{new Dimension().withName("AutoScalingGroupName").withValue("targetAutoScalingGroup"), new Dimension().withName("TopicName").withValue("sourceTopicName")}).withThreshold(Double.valueOf(50.0));
    }
}

