/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery.ec2;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Tag;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import pl.codewise.commons.aws.cqrs.discovery.ec2.AmiDiscovery;
import pl.codewise.commons.aws.cqrs.model.ec2.Ami;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsResourceTag;

@RunWith(value=MockitoJUnitRunner.class)
public class AmiDiscoveryTest {
    private static final String ROOT_DEVICE_TYPE = "root-device-type";
    private static final String EBS = "ebs";
    private static final String IMAGE_ID = "ami-654cba";
    private static final String IMAGE_NAME = "some image name";
    private static final String CREATION_DATE = "2017-03-07T07:51:38.000Z";
    private static final String TAG_KEY = "tag:some key";
    private static final String TAG_VALUE = "some value";
    @Mock
    private AmazonEC2 amazonEC2;

    @Test
    public void shouldFindAmiByImageId() {
        this.givenAmiWithImageId(IMAGE_ID);
        AmiDiscovery amiDiscovery = new AmiDiscovery(this.amazonEC2);
        Optional ami = amiDiscovery.findAmi(IMAGE_ID);
        ((OptionalAssert)Assertions.assertThat((Optional)ami).isPresent()).hasValue((Object)this.expectedAmi());
    }

    @Test
    public void shouldFindAmisByFilters() {
        this.givenAmiWithTag(TAG_KEY, TAG_VALUE);
        AmiDiscovery amiDiscovery = new AmiDiscovery(this.amazonEC2);
        List amis = amiDiscovery.findAmisByFilters(Arrays.asList(Pair.of((Object)TAG_KEY, (Object)TAG_VALUE), Pair.of((Object)ROOT_DEVICE_TYPE, (Object)EBS)));
        Assertions.assertThat((List)amis).containsOnly((Object[])new Ami[]{this.expectedAmi()});
    }

    private Ami expectedAmi() {
        return new Ami(IMAGE_ID, IMAGE_NAME, ZonedDateTime.parse(CREATION_DATE), EBS, Collections.singletonList(AwsResourceTag.create((String)TAG_KEY, (String)TAG_VALUE)));
    }

    private void givenAmiWithImageId(String imageId) {
        BDDMockito.given((Object)this.amazonEC2.describeImages(new DescribeImagesRequest().withImageIds(new String[]{imageId}))).willReturn((Object)new DescribeImagesResult().withImages(new Image[]{this.image(imageId, new Tag(TAG_KEY, TAG_VALUE))}));
    }

    private void givenAmiWithTag(String tagKey, String tagValue) {
        BDDMockito.given((Object)this.amazonEC2.describeImages(new DescribeImagesRequest().withFilters(new Filter[]{new Filter().withName(tagKey).withValues(new String[]{tagValue}), new Filter().withName(ROOT_DEVICE_TYPE).withValues(new String[]{EBS})}))).willReturn((Object)new DescribeImagesResult().withImages(new Image[]{this.image(IMAGE_ID, new Tag(tagKey, tagValue))}));
    }

    private Image image(String imageId, Tag tag) {
        return new Image().withImageId(imageId).withName(IMAGE_NAME).withCreationDate(CREATION_DATE).withRootDeviceType(EBS).withTags(new Tag[]{tag});
    }
}

