/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AmazonEC2Exception;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.SecurityGroup;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.OngoingStubbing;
import pl.codewise.commons.aws.cqrs.discovery.SecurityGroupDiscovery;

@RunWith(value=MockitoJUnitRunner.class)
public class SecurityGroupDiscoveryTest {
    private final String expectedSecurityGroupName = "test-sg";
    private final String expectedVpcId = "vpc-12345678";
    @Mock
    private AmazonEC2 amazonEC2;
    @InjectMocks
    private SecurityGroupDiscovery discovery;

    @Test
    public void shouldFailWhenUnableToFetchSecurityGroups() {
        this.whenDescribeSecurityGroupsRequested().thenThrow(new Throwable[]{new AmazonEC2Exception("UnableToFetchSecurityGroups")});
        boolean result = this.discovery.hasSecurityGroupInVpc("test-sg", "vpc-12345678");
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void shouldRespondWhenGroupNotFound() {
        this.whenDescribeSecurityGroupsRequested().thenReturn((Object)this.resultWithSecurityGroups(this.securityGroup("test-sg", "vpc-98765432")));
        boolean result = this.discovery.hasSecurityGroupInVpc("test-sg", "vpc-12345678");
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void shouldRespondWhenGroupFound() {
        this.whenDescribeSecurityGroupsRequested().thenReturn((Object)this.resultWithSecurityGroups(this.securityGroup("test-sg", "vpc-98765432"), this.securityGroup("test-sg", "vpc-12345678")));
        boolean result = this.discovery.hasSecurityGroupInVpc("test-sg", "vpc-12345678");
        Assertions.assertThat((boolean)result).isTrue();
    }

    private OngoingStubbing<DescribeSecurityGroupsResult> whenDescribeSecurityGroupsRequested() {
        return Mockito.when((Object)this.amazonEC2.describeSecurityGroups(new DescribeSecurityGroupsRequest().withGroupNames(new String[]{"test-sg"})));
    }

    private DescribeSecurityGroupsResult resultWithSecurityGroups(SecurityGroup ... securityGroups) {
        return new DescribeSecurityGroupsResult().withSecurityGroups(securityGroups);
    }

    private SecurityGroup securityGroup(String groupName, String vpcId) {
        return new SecurityGroup().withGroupName(groupName).withVpcId(vpcId);
    }
}

