/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import pl.codewise.commons.aws.cqrs.discovery.S3Discovery;
import pl.codewise.commons.aws.cqrs.operations.s3.S3TestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class S3DiscoveryTest {
    private final String bucketName = "test-bucket";
    private S3Discovery s3Discovery;
    @Mock
    private AmazonS3 amazonS3;

    @Before
    public void setUp() {
        this.s3Discovery = new S3Discovery(this.amazonS3);
    }

    @Test
    public void shouldReturnTrueForExistingBucket() {
        this.givenSingleExistingBucketWithName("test-bucket");
        boolean hasBucketNamed = this.s3Discovery.hasBucketNamed("test-bucket");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasBucketNamed).describedAs("Existence of bucket that does exist in S3", new Object[0])).isTrue();
    }

    @Test
    public void shouldReturnFalseForNonExistingBucket() {
        this.givenSingleExistingBucketWithName("test-bucket");
        boolean hasBucketNamed = this.s3Discovery.hasBucketNamed("test-bucket-not-existing");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasBucketNamed).describedAs("Existence of bucket that does not exist in S3", new Object[0])).isFalse();
    }

    @Test
    public void shouldThrowWhenRetrievingBucketWithNameNull() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.s3Discovery.hasBucketNamed(null));
    }

    @Test
    public void shouldListObjects() {
        List<String> expectedKeys = Arrays.asList("test-prefix/abc", "test-prefix/abc/def", "test-prefix/ghi");
        S3TestUtils.fillInS3Bucket(this.amazonS3, "test-bucket", "test-prefix", expectedKeys);
        List keys = this.s3Discovery.listObjects("test-bucket", "test-prefix");
        Assertions.assertThat((List)keys).containsAll(expectedKeys);
    }

    private void givenSingleExistingBucketWithName(String bucketName) {
        Mockito.when((Object)this.amazonS3.listBuckets()).thenReturn(Collections.singletonList(this.newBucket(bucketName)));
    }

    private Bucket newBucket(String name) {
        return new Bucket(name);
    }
}

