/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.route53domains.AmazonRoute53Domains;
import com.amazonaws.services.route53domains.model.CheckDomainAvailabilityRequest;
import com.amazonaws.services.route53domains.model.CheckDomainAvailabilityResult;
import com.amazonaws.services.route53domains.model.DomainAvailability;
import com.amazonaws.services.route53domains.model.DomainSummary;
import com.amazonaws.services.route53domains.model.GetOperationDetailRequest;
import com.amazonaws.services.route53domains.model.GetOperationDetailResult;
import com.amazonaws.services.route53domains.model.ListDomainsRequest;
import com.amazonaws.services.route53domains.model.ListDomainsResult;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import pl.codewise.commons.aws.cqrs.discovery.Route53DomainsDiscovery;
import pl.codewise.commons.aws.cqrs.discovery.route53.domains.Route53DomainsSettings;
import pl.codewise.commons.aws.cqrs.model.route53.AwsBasicDomain;
import pl.codewise.commons.aws.cqrs.model.route53.AwsDomainRegistrationStatus;
import pl.codewise.commons.aws.cqrs.utils.Awaitilities;

public class Route53DomainsDiscoveryTest {
    private static final int TIMEOUT_MILLIS = 400;
    private static final int POLL_INTERVAL_MILLIS = 100;
    private AmazonRoute53Domains amazonRoute53Domains;
    private Route53DomainsDiscovery route53DomainsDiscovery;

    @Before
    public void setUp() {
        this.amazonRoute53Domains = (AmazonRoute53Domains)Mockito.mock(AmazonRoute53Domains.class);
        this.route53DomainsDiscovery = new Route53DomainsDiscovery(this.amazonRoute53Domains, Route53DomainsSettings.builder().setPollIntervalMillis(100).setTimeoutMillis(400).build(), new Awaitilities());
    }

    @Test
    public void shouldReturnTrueWhenDomainIsAvailable() {
        CheckDomainAvailabilityRequest availabilityRequest = new CheckDomainAvailabilityRequest().withDomainName("domain.com");
        Mockito.when((Object)this.amazonRoute53Domains.checkDomainAvailability(availabilityRequest)).thenReturn((Object)this.domainStatus(DomainAvailability.AVAILABLE.toString()));
        boolean domainAvailable = this.route53DomainsDiscovery.isDomainAvailableForRegistration("domain.com");
        Assertions.assertThat((boolean)domainAvailable).isTrue();
        ((AmazonRoute53Domains)Mockito.verify((Object)this.amazonRoute53Domains)).checkDomainAvailability(availabilityRequest);
    }

    @Test
    public void shouldReturnFalseWhenDomainIsNotAvailable() {
        CheckDomainAvailabilityRequest availabilityRequest = new CheckDomainAvailabilityRequest().withDomainName("domain2.com");
        Mockito.when((Object)this.amazonRoute53Domains.checkDomainAvailability(availabilityRequest)).thenReturn((Object)this.domainStatus(DomainAvailability.UNAVAILABLE.toString()));
        boolean domainAvailable = this.route53DomainsDiscovery.isDomainAvailableForRegistration("domain2.com");
        Assertions.assertThat((boolean)domainAvailable).isFalse();
        ((AmazonRoute53Domains)Mockito.verify((Object)this.amazonRoute53Domains)).checkDomainAvailability(availabilityRequest);
    }

    @Test
    public void shouldResubmitRequestsWhenAvailabilityStatusPending() {
        CheckDomainAvailabilityRequest availabilityRequest = new CheckDomainAvailabilityRequest().withDomainName("domain3.com");
        Mockito.when((Object)this.amazonRoute53Domains.checkDomainAvailability(availabilityRequest)).thenReturn((Object)this.domainStatus("PENDING"), (Object[])new CheckDomainAvailabilityResult[]{this.domainStatus("PENDING"), this.domainStatus(DomainAvailability.AVAILABLE.toString())});
        boolean status = this.route53DomainsDiscovery.isDomainAvailableForRegistration("domain3.com");
        Assertions.assertThat((boolean)status).isEqualTo(true);
        ((AmazonRoute53Domains)Mockito.verify((Object)this.amazonRoute53Domains, (VerificationMode)Mockito.times((int)3))).checkDomainAvailability(availabilityRequest);
    }

    @Test
    public void shouldUseRateLimiterWhenProvided() {
        RateLimiter rateLimiter = (RateLimiter)Mockito.mock(RateLimiter.class);
        Route53DomainsDiscovery route53DomainsDiscovery = new Route53DomainsDiscovery(this.amazonRoute53Domains, Route53DomainsSettings.builder().setPollIntervalMillis(100).setTimeoutMillis(400).setRateLimiter(rateLimiter).build(), new Awaitilities());
        Mockito.when((Object)this.amazonRoute53Domains.checkDomainAvailability(new CheckDomainAvailabilityRequest().withDomainName("domain2.com"))).thenReturn((Object)this.domainStatus(DomainAvailability.UNAVAILABLE.toString()));
        route53DomainsDiscovery.isDomainAvailableForRegistration("domain2.com");
        ((RateLimiter)Mockito.verify((Object)rateLimiter)).acquire();
    }

    @Test
    public void shouldResubmitWhenTimeoutThresholdReached() {
        CheckDomainAvailabilityRequest availabilityRequest = new CheckDomainAvailabilityRequest().withDomainName("domain4.com");
        Mockito.when((Object)this.amazonRoute53Domains.checkDomainAvailability(availabilityRequest)).thenReturn((Object)this.domainStatus("PENDING"), (Object[])new CheckDomainAvailabilityResult[]{this.domainStatus("PENDING"), this.domainStatus("PENDING"), this.domainStatus("PENDING"), this.domainStatus("PENDING"), this.domainStatus(DomainAvailability.AVAILABLE.toString())});
        boolean status = this.route53DomainsDiscovery.isDomainAvailableForRegistration("domain4.com");
        Assertions.assertThat((boolean)status).isEqualTo(false);
        ((AmazonRoute53Domains)Mockito.verify((Object)this.amazonRoute53Domains, (VerificationMode)Mockito.atLeast((int)1))).checkDomainAvailability(availabilityRequest);
    }

    @Test
    public void shouldReadDomainRegistrationStatus() {
        Date now = new Date();
        GetOperationDetailResult awsResult = new GetOperationDetailResult().withOperationId("operation id").withStatus("status").withMessage("message").withDomainName("domain name").withType("type").withSubmittedDate(now);
        GetOperationDetailRequest getOperationDetailRequest = new GetOperationDetailRequest().withOperationId("operation id");
        Mockito.when((Object)this.amazonRoute53Domains.getOperationDetail(getOperationDetailRequest)).thenReturn((Object)awsResult);
        AwsDomainRegistrationStatus status = this.route53DomainsDiscovery.getDomainRegistrationStatus("operation id");
        AwsDomainRegistrationStatus expectedStatus = new AwsDomainRegistrationStatus("operation id", "status", "message", "domain name", "type", now);
        Assertions.assertThat((Object)status).isEqualTo((Object)expectedStatus);
    }

    @Test
    public void shouldReturnDomainsCount() {
        ListDomainsRequest request1 = new ListDomainsRequest().withMaxItems(Integer.valueOf(100));
        ListDomainsRequest request2 = new ListDomainsRequest().withMaxItems(Integer.valueOf(100)).withMarker("TEST_MARKER");
        DomainSummary domain = new DomainSummary();
        ListDomainsResult result1 = new ListDomainsResult().withNextPageMarker("TEST_MARKER").withDomains(new DomainSummary[]{domain, domain, domain});
        ListDomainsResult result2 = new ListDomainsResult().withDomains(new DomainSummary[]{domain, domain});
        Mockito.when((Object)this.amazonRoute53Domains.listDomains(request1)).thenReturn((Object)result1);
        Mockito.when((Object)this.amazonRoute53Domains.listDomains(request2)).thenReturn((Object)result2);
        int domainsCount = this.route53DomainsDiscovery.getDomainsCount();
        Assertions.assertThat((int)domainsCount).isEqualTo(5);
    }

    @Test
    public void shouldReturnAllDomainsMatchingFilter() {
        ListDomainsRequest request1 = new ListDomainsRequest().withMaxItems(Integer.valueOf(100));
        ListDomainsRequest request2 = new ListDomainsRequest().withMaxItems(Integer.valueOf(100)).withMarker("TEST_MARKER");
        Date expiry = new Date();
        DomainSummary nonMatching1 = new DomainSummary().withDomainName("1").withAutoRenew(Boolean.valueOf(false)).withExpiry(expiry);
        DomainSummary matching1 = new DomainSummary().withDomainName("2").withAutoRenew(Boolean.valueOf(true)).withExpiry(expiry);
        ListDomainsResult result1 = new ListDomainsResult().withNextPageMarker("TEST_MARKER").withDomains(new DomainSummary[]{nonMatching1, matching1});
        DomainSummary matching2 = new DomainSummary().withDomainName("3").withAutoRenew(Boolean.valueOf(true)).withExpiry(expiry);
        DomainSummary nonMatching2 = new DomainSummary().withDomainName("4").withAutoRenew(Boolean.valueOf(false)).withExpiry(expiry);
        ListDomainsResult result2 = new ListDomainsResult().withDomains(new DomainSummary[]{matching2, nonMatching2});
        Mockito.when((Object)this.amazonRoute53Domains.listDomains(request1)).thenReturn((Object)result1);
        Mockito.when((Object)this.amazonRoute53Domains.listDomains(request2)).thenReturn((Object)result2);
        List result = this.route53DomainsDiscovery.getAllDomains(AwsBasicDomain::isAutoRenew);
        Assertions.assertThat((List)result).containsOnly((Object[])new AwsBasicDomain[]{new AwsBasicDomain(matching1.getDomainName(), matching1.isAutoRenew().booleanValue(), matching1.getExpiry().toInstant()), new AwsBasicDomain(matching2.getDomainName(), matching2.isAutoRenew().booleanValue(), matching2.getExpiry().toInstant())});
    }

    private CheckDomainAvailabilityResult domainStatus(String availability) {
        return new CheckDomainAvailabilityResult().withAvailability(availability);
    }
}

