/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.model.ChangeInfo;
import com.amazonaws.services.route53.model.ChangeStatus;
import com.amazonaws.services.route53.model.GetChangeRequest;
import com.amazonaws.services.route53.model.GetChangeResult;
import com.amazonaws.services.route53.model.GetHealthCheckCountResult;
import com.amazonaws.services.route53.model.GetHostedZoneCountResult;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import pl.codewise.commons.aws.cqrs.discovery.Route53Discovery;
import pl.codewise.commons.aws.cqrs.model.route53.AwsChangeInfo;
import pl.codewise.commons.aws.cqrs.utils.Awaitilities;

public class Route53DiscoveryTest {
    private static final long POLL_INTERVAL_MS = 50L;
    private Route53Discovery route53Discovery;
    private AmazonRoute53 amazonRoute53;
    private Awaitilities awaitilities;

    @Before
    public void setUp() {
        this.amazonRoute53 = (AmazonRoute53)Mockito.mock(AmazonRoute53.class);
        this.awaitilities = (Awaitilities)Mockito.mock(Awaitilities.class);
        this.route53Discovery = new Route53Discovery(this.amazonRoute53, this.awaitilities, 50L);
    }

    @Test
    public void shouldReturnAllHostedZones() {
        Mockito.when((Object)this.amazonRoute53.listHostedZones()).thenReturn((Object)new ListHostedZonesResult().withHostedZones(Collections.emptyList()));
        this.route53Discovery.listHostedZones();
        ((AmazonRoute53)Mockito.verify((Object)this.amazonRoute53)).listHostedZones();
    }

    @Test
    public void shouldReturnAllHostedZonesWithPaging() {
        Mockito.when((Object)this.amazonRoute53.listHostedZones()).thenReturn((Object)new ListHostedZonesResult().withHostedZones(Collections.emptyList()).withIsTruncated(Boolean.valueOf(true)));
        Mockito.when((Object)this.amazonRoute53.listHostedZones((ListHostedZonesRequest)ArgumentMatchers.any(ListHostedZonesRequest.class))).thenReturn((Object)new ListHostedZonesResult().withHostedZones(Collections.emptyList()));
        this.route53Discovery.listHostedZones();
        ((AmazonRoute53)Mockito.verify((Object)this.amazonRoute53)).listHostedZones();
        ((AmazonRoute53)Mockito.verify((Object)this.amazonRoute53)).listHostedZones((ListHostedZonesRequest)ArgumentMatchers.any(ListHostedZonesRequest.class));
    }

    @Test
    public void shouldReturnHostedZonesCount() {
        Mockito.when((Object)this.amazonRoute53.getHostedZoneCount()).thenReturn((Object)new GetHostedZoneCountResult().withHostedZoneCount(Long.valueOf(45L)));
        int result = this.route53Discovery.getHostedZonesCount();
        Assertions.assertThat((int)result).isEqualTo(45);
    }

    @Test
    public void shouldReturnHealthCheckCount() {
        Mockito.when((Object)this.amazonRoute53.getHealthCheckCount()).thenReturn((Object)new GetHealthCheckCountResult().withHealthCheckCount(Long.valueOf(67L)));
        int result = this.route53Discovery.getHealthChecksCount();
        Assertions.assertThat((int)result).isEqualTo(67);
    }

    @Test
    public void shouldListRecordSetsForHostedZone() {
        Mockito.when((Object)this.amazonRoute53.listResourceRecordSets((ListResourceRecordSetsRequest)ArgumentMatchers.any(ListResourceRecordSetsRequest.class))).thenReturn((Object)new ListResourceRecordSetsResult().withResourceRecordSets(Collections.emptyList()));
        this.route53Discovery.listRecordSets("asd");
        ((AmazonRoute53)Mockito.verify((Object)this.amazonRoute53)).listResourceRecordSets((ListResourceRecordSetsRequest)ArgumentMatchers.any());
    }

    @Test
    public void shouldListRecordSetsForHostedZoneWithPaging() {
        Mockito.when((Object)this.amazonRoute53.listResourceRecordSets((ListResourceRecordSetsRequest)ArgumentMatchers.any(ListResourceRecordSetsRequest.class))).thenReturn((Object)new ListResourceRecordSetsResult().withResourceRecordSets(Collections.emptyList()).withIsTruncated(Boolean.valueOf(true)), (Object[])new ListResourceRecordSetsResult[]{new ListResourceRecordSetsResult().withResourceRecordSets(Collections.emptyList())});
        this.route53Discovery.listRecordSets("asd");
        ((AmazonRoute53)Mockito.verify((Object)this.amazonRoute53, (VerificationMode)Mockito.times((int)2))).listResourceRecordSets((ListResourceRecordSetsRequest)ArgumentMatchers.any());
    }

    @Test
    public void shouldWaitForChangeTillItIsPending() {
        ((Awaitilities)Mockito.doAnswer(invocation -> {
            ((Callable)invocation.getArgument(3)).call();
            return null;
        }).when((Object)this.awaitilities)).awaitTillActionSucceed(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyString(), (Callable)ArgumentMatchers.any(Callable.class));
        Mockito.when((Object)this.amazonRoute53.getChange((GetChangeRequest)ArgumentMatchers.any())).thenReturn((Object)new GetChangeResult().withChangeInfo(new ChangeInfo().withStatus(ChangeStatus.INSYNC)));
        AwsChangeInfo result = this.route53Discovery.waitForChange(new AwsChangeInfo.Builder().withStatus("PENDING").build(), 1000L);
        Assertions.assertThat((String)result.getStatus()).isEqualTo((Object)"INSYNC");
    }

    @Test
    public void shouldNotWaitIfOperationIsAlreadyFinished() {
        AwsChangeInfo changeInfo = new AwsChangeInfo.Builder().withStatus("INSYNC").build();
        AwsChangeInfo result = this.route53Discovery.waitForChange(changeInfo, 1000L);
        Assertions.assertThat((Object)result).isEqualTo((Object)changeInfo);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.awaitilities});
    }
}

