/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsResult;
import com.amazonaws.services.autoscaling.model.LaunchConfiguration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import pl.codewise.commons.aws.cqrs.discovery.LaunchConfigurationDiscovery;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsLaunchConfiguration;

@RunWith(value=MockitoJUnitRunner.class)
public class LaunchConfigurationDiscoveryTest {
    private static final String NAME = "test-lc";
    private static final String USER_DATA = "some user data";
    private static final String IAM_INSTANCE_PROFILE = "instance profile name";
    private LaunchConfigurationDiscovery discovery;
    @Mock
    private AmazonAutoScaling amazonAutoScaling;

    @Before
    public void setUp() {
        this.discovery = new LaunchConfigurationDiscovery(this.amazonAutoScaling);
    }

    @Test
    public void shouldReturnNullWhenNoMatchingLaunchConfigurationFound() {
        this.givenNoMatchingConfiguration();
        AwsLaunchConfiguration result = this.discovery.getLaunchConfiguration(NAME);
        Assertions.assertThat((Object)result).isNull();
    }

    @Test
    public void shouldReturnConfigurationWhenOneWasFound() {
        LocalDateTime creationTime = LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS);
        this.givenExistingConfiguration(creationTime);
        AwsLaunchConfiguration result = this.discovery.getLaunchConfiguration(NAME);
        Assertions.assertThat((Object)result).isEqualTo((Object)AwsLaunchConfiguration.builder().withName(NAME).withIamInstanceProfile(IAM_INSTANCE_PROFILE).withUserData(USER_DATA).withInstanceMonitoring(Boolean.valueOf(false)).withCreationTime(creationTime).build());
    }

    private void givenNoMatchingConfiguration() {
        DescribeLaunchConfigurationsRequest request = new DescribeLaunchConfigurationsRequest().withLaunchConfigurationNames(new String[]{NAME});
        this.mockResponse(request, Collections.emptyList());
    }

    private void givenExistingConfiguration(LocalDateTime creationDate) {
        Instant instant = creationDate.toInstant(ZoneOffset.UTC);
        DescribeLaunchConfigurationsRequest request = new DescribeLaunchConfigurationsRequest().withLaunchConfigurationNames(new String[]{NAME});
        this.mockResponse(request, Collections.singletonList(new LaunchConfiguration().withLaunchConfigurationName(NAME).withUserData(LaunchConfigurationDiscovery.ENCODER.encodeToString(USER_DATA.getBytes())).withIamInstanceProfile(IAM_INSTANCE_PROFILE).withCreatedTime(Date.from(instant))));
    }

    private void mockResponse(DescribeLaunchConfigurationsRequest request, List<LaunchConfiguration> configurations) {
        Mockito.when((Object)this.amazonAutoScaling.describeLaunchConfigurations(request)).thenReturn((Object)new DescribeLaunchConfigurationsResult().withLaunchConfigurations(configurations));
    }
}

