/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.AmazonIdentityManagementException;
import com.amazonaws.services.identitymanagement.model.AttachedPolicy;
import com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.GetInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.GetRoleRequest;
import com.amazonaws.services.identitymanagement.model.GetRoleResult;
import com.amazonaws.services.identitymanagement.model.InstanceProfile;
import com.amazonaws.services.identitymanagement.model.ListAttachedRolePoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListAttachedRolePoliciesResult;
import com.amazonaws.services.identitymanagement.model.ListPoliciesRequest;
import com.amazonaws.services.identitymanagement.model.ListPoliciesResult;
import com.amazonaws.services.identitymanagement.model.ListServerCertificatesResult;
import com.amazonaws.services.identitymanagement.model.NoSuchEntityException;
import com.amazonaws.services.identitymanagement.model.Policy;
import com.amazonaws.services.identitymanagement.model.Role;
import com.amazonaws.services.identitymanagement.model.ServerCertificateMetadata;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.OngoingStubbing;
import pl.codewise.commons.aws.cqrs.discovery.IamDiscovery;

@RunWith(value=MockitoJUnitRunner.class)
public class IamDiscoveryTest {
    private final String policy1 = "test-policy-1";
    private final String policy2 = "test-policy-2";
    private final String nonExistingPolicy = "non-existing-policy";
    private final String arnPrefix = "arn:aws:iam::123456789012:";
    private final String role1 = "test-role-1";
    private final String role2 = "test-role-2";
    private final String profileName = "test-profile";
    @Mock
    private AmazonIdentityManagement amazonIdentityManagement;
    @InjectMocks
    private IamDiscovery iamDiscovery;

    @Test
    public void shouldReportNonExistingRole() {
        this.whenGetRoleRequested("test-role-1").thenThrow(new Throwable[]{new AmazonIdentityManagementException("RoleDoesNotExist")});
        boolean result = this.iamDiscovery.hasRole("test-role-1");
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void shouldReportExistingRole() {
        this.whenGetRoleRequested("test-role-1").thenReturn((Object)this.getRoleResultWithArn(this.prefixed("test-role-1")));
        boolean result = this.iamDiscovery.hasRole("test-role-1");
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    public void shouldGetRoleArn() {
        this.whenGetRoleRequested("test-role-1").thenReturn((Object)this.getRoleResultWithArn(this.prefixed("test-role-1")));
        Optional roleArn = this.iamDiscovery.getRoleArn("test-role-1");
        ((OptionalAssert)Assertions.assertThat((Optional)roleArn).isPresent()).hasValue((Object)this.prefixed("test-role-1"));
    }

    @Test
    public void shouldReportNonExistingInstanceProfile() {
        this.whenGetInstanceProfileRequested("test-profile").thenThrow(new Throwable[]{new NoSuchEntityException("Not found")});
        boolean result = this.iamDiscovery.hasInstanceProfile("test-profile");
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void shouldReportExistingInstanceProfile() {
        this.whenGetInstanceProfileRequested("test-profile").thenReturn((Object)this.resultWithInstanceProfileArn(this.prefixed("test-profile")));
        boolean result = this.iamDiscovery.hasInstanceProfile("test-profile");
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    public void shouldGetInstanceProfileArn() {
        this.whenGetInstanceProfileRequested("test-profile").thenReturn((Object)this.resultWithInstanceProfileArn(this.prefixed("test-profile")));
        Optional instanceProfileArn = this.iamDiscovery.getInstanceProfileArn("test-profile");
        ((OptionalAssert)Assertions.assertThat((Optional)instanceProfileArn).isPresent()).hasValue((Object)this.prefixed("test-profile"));
    }

    @Test
    public void shouldReturnFalseForNonExistingPolicy() {
        this.givenPolicies("test-policy-1");
        boolean hasPolicy = this.iamDiscovery.hasPolicy("non-existing-policy");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasPolicy).as("Result of existence check of a non-existing policy", new Object[0])).isFalse();
    }

    @Test
    public void shouldReturnTrueForExistingPolicy() {
        this.givenPolicies("test-policy-1", "test-policy-2");
        boolean hasPolicy = this.iamDiscovery.hasPolicy("test-policy-2");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasPolicy).as("Result of existence check of an existing policy", new Object[0])).isTrue();
    }

    @Test
    public void shouldNotReturnAnyPolicies() {
        String roleName = "test-role";
        Mockito.when((Object)this.amazonIdentityManagement.listAttachedRolePolicies(new ListAttachedRolePoliciesRequest().withRoleName(roleName))).thenThrow(new Throwable[]{new AmazonIdentityManagementException("NoSuchRole")});
        List policies = this.iamDiscovery.getAttachedPoliciesArnsForRole(roleName);
        Assertions.assertThat((List)policies).isEmpty();
    }

    @Test
    public void shouldNotReturnAnyPoliciesWhenNoAttached() {
        String roleName = "test-role";
        Mockito.when((Object)this.amazonIdentityManagement.listAttachedRolePolicies(new ListAttachedRolePoliciesRequest().withRoleName(roleName))).thenReturn((Object)this.attachedPolicies(Collections.emptyList()));
        List policies = this.iamDiscovery.getAttachedPoliciesArnsForRole(roleName);
        Assertions.assertThat((List)policies).isEmpty();
    }

    @Test
    public void shouldReturnPoliciesArns() {
        String roleName = "test-role";
        Mockito.when((Object)this.amazonIdentityManagement.listAttachedRolePolicies(new ListAttachedRolePoliciesRequest().withRoleName(roleName))).thenReturn((Object)this.attachedPolicies(Arrays.asList(this.attachedPolicy("test-policy-1"), this.attachedPolicy("test-policy-2"))));
        List policies = this.iamDiscovery.getAttachedPoliciesArnsForRole(roleName);
        Assertions.assertThat((List)policies).containsExactly((Object[])new String[]{this.prefixed("test-policy-1"), this.prefixed("test-policy-2")});
    }

    @Test
    public void shouldNotReturnAnyRoles() {
        this.whenGetInstanceProfileRequested("test-profile").thenThrow(new Throwable[]{new AmazonIdentityManagementException("NoSuchProfile")});
        List roles = this.iamDiscovery.getInstanceProfileRoles("test-profile");
        Assertions.assertThat((List)roles).isEmpty();
    }

    @Test
    public void shouldReturnInstanceProfileRoles() {
        this.whenGetInstanceProfileRequested("test-profile").thenReturn((Object)this.resultWithRoleNames("test-role-1", "test-role-2"));
        List roles = this.iamDiscovery.getInstanceProfileRoles("test-profile");
        Assertions.assertThat((List)roles).containsExactly((Object[])new String[]{"test-role-1", "test-role-2"});
    }

    @Test
    public void shouldNotReturnCertificateArn() {
        Mockito.when((Object)this.amazonIdentityManagement.listServerCertificates()).thenReturn((Object)this.serverCertificates("other-certificate"));
        Optional serverCertificateArn = this.iamDiscovery.getServerCertificateArn("test-certificate");
        Assertions.assertThat((Optional)serverCertificateArn).isNotPresent();
    }

    @Test
    public void shouldReturnCertificateArn() {
        Mockito.when((Object)this.amazonIdentityManagement.listServerCertificates()).thenReturn((Object)this.serverCertificates("test-certificate"));
        Optional serverCertificateArn = this.iamDiscovery.getServerCertificateArn("test-certificate");
        ((OptionalAssert)Assertions.assertThat((Optional)serverCertificateArn).isPresent()).hasValue((Object)this.arnPrefixedCertificate("test-certificate"));
    }

    private OngoingStubbing<GetRoleResult> whenGetRoleRequested(String role1) {
        return Mockito.when((Object)this.amazonIdentityManagement.getRole(new GetRoleRequest().withRoleName(role1)));
    }

    private GetRoleResult getRoleResultWithArn(String arn) {
        return new GetRoleResult().withRole(new Role().withArn(arn));
    }

    private void givenPolicies(String ... names) {
        ListPoliciesResult listPoliciesResult = this.listPolicies(Arrays.asList(names));
        Mockito.when((Object)this.amazonIdentityManagement.listPolicies((ListPoliciesRequest)ArgumentMatchers.any())).thenReturn((Object)listPoliciesResult);
    }

    private ListPoliciesResult listPolicies(Collection<String> names) {
        List<Policy> policies = this.mapNamesToPolicies(names);
        return new ListPoliciesResult().withPolicies(policies).withIsTruncated(Boolean.valueOf(false));
    }

    private List<Policy> mapNamesToPolicies(Collection<String> names) {
        return names.stream().map(name -> new Policy().withPolicyName(name).withArn(this.prefixed((String)name))).collect(Collectors.toList());
    }

    private AttachedPolicy attachedPolicy(String policyName) {
        return new AttachedPolicy().withPolicyArn(this.prefixed(policyName));
    }

    private ListAttachedRolePoliciesResult attachedPolicies(List<AttachedPolicy> attachedPolicies) {
        return new ListAttachedRolePoliciesResult().withAttachedPolicies(attachedPolicies);
    }

    private String prefixed(String policyName) {
        return "arn:aws:iam::123456789012:" + policyName;
    }

    private OngoingStubbing<GetInstanceProfileResult> whenGetInstanceProfileRequested(String profileName) {
        return Mockito.when((Object)this.amazonIdentityManagement.getInstanceProfile(new GetInstanceProfileRequest().withInstanceProfileName(profileName)));
    }

    private GetInstanceProfileResult resultWithRoleNames(String ... roleNames) {
        List roles = Arrays.stream(roleNames).map(this::roleNamed).collect(Collectors.toList());
        return new GetInstanceProfileResult().withInstanceProfile(new InstanceProfile().withRoles(roles));
    }

    private GetInstanceProfileResult resultWithInstanceProfileArn(String arn) {
        return new GetInstanceProfileResult().withInstanceProfile(new InstanceProfile().withArn(arn));
    }

    private Role roleNamed(String roleName) {
        return new Role().withRoleName(roleName);
    }

    private ListServerCertificatesResult serverCertificates(String ... serverCertificateNames) {
        List metadata = Arrays.stream(serverCertificateNames).map(this::serverCertificateMetadata).collect(Collectors.toList());
        return new ListServerCertificatesResult().withServerCertificateMetadataList(metadata);
    }

    private ServerCertificateMetadata serverCertificateMetadata(String serverCertificateName) {
        return new ServerCertificateMetadata().withServerCertificateName(serverCertificateName).withArn(this.arnPrefixedCertificate(serverCertificateName));
    }

    private String arnPrefixedCertificate(String serverCertificateName) {
        return "arn:aws:iam::123456789012:server-certificate/" + serverCertificateName;
    }
}

