/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.AutoScalingInstanceDetails;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesResult;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.SpotInstanceStatus;
import com.amazonaws.services.ec2.model.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import pl.codewise.commons.aws.cqrs.discovery.Ec2Discovery;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsResourceTag;
import pl.codewise.commons.aws.cqrs.utils.Awaitilities;

@RunWith(value=MockitoJUnitRunner.class)
public class Ec2DiscoveryTest {
    @Mock
    private AmazonEC2 amazonEC2;
    @Mock
    private AmazonAutoScaling amazonAutoScaling;

    @Test
    public void shouldReturnAllInstances() {
        this.givenDescribeAnyInstances();
        this.givenDescribeAnyAutoScalingInstances();
        Ec2Discovery ec2Discovery = this.createEc2Discovery();
        ec2Discovery.getAllInstances();
        ((AmazonEC2)Mockito.verify((Object)this.amazonEC2)).describeInstances(new DescribeInstancesRequest());
    }

    @Test
    public void shouldReturnSelectedInstances() {
        this.givenDescribeAnyInstances();
        this.givenDescribeAnyAutoScalingInstances();
        Ec2Discovery ec2Discovery = this.createEc2Discovery();
        ec2Discovery.getInstances(Arrays.asList("i-1", "i-2"));
        ((AmazonEC2)Mockito.verify((Object)this.amazonEC2)).describeInstances(new DescribeInstancesRequest().withInstanceIds(new String[]{"i-1", "i-2"}));
    }

    @Test
    public void shouldNotReturnAnyInstanceWhenNotGivenAnyId() {
        Ec2Discovery ec2Discovery = new Ec2Discovery("mars-north-1", null, this.amazonAutoScaling, new Awaitilities(), 10L);
        List instances = ec2Discovery.getInstances(Collections.emptyList());
        Assertions.assertThat((List)instances).isEmpty();
    }

    @Test
    public void shouldReturnEmptyInstanceName() {
        this.givenDescribeAnyInstances();
        Ec2Discovery ec2Discovery = this.createEc2Discovery();
        String instanceNameTag = ec2Discovery.retrieveInstanceNameTag("i-11111111");
        Assertions.assertThat((String)instanceNameTag).isEmpty();
    }

    @Test
    public void shouldGetInstancesWithInformationFromAutoScalingGroup() {
        this.givenEc2WithTwoInstances();
        this.givenAutoScalingWithTwoInstances();
        this.givenSpotRequestsWithTwoInstances();
        Ec2Discovery ec2Discovery = this.createEc2Discovery();
        List instances = ec2Discovery.getInstances(Arrays.asList("i-1", "i-2"));
        Assertions.assertThat((List)instances).extracting(new Function[]{AwsInstance::getInstanceId, instance -> instance.getAutoScalingDetails().getLaunchConfigurationName(), instance -> instance.getAutoScalingDetails().getAvailabilityZone(), instance -> instance.getSpotRequestDetails().getRequestId()}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"i-1", "lc-1", "az-1", "sir-1"}), Assertions.tuple((Object[])new Object[]{"i-2", "lc-2", "az-2", "sir-2"})});
    }

    @Test
    public void shouldGetInstancesWithAssociatedTags() {
        this.givenInstanceWithTags("id-123456", new Tag("john", "doe"), new Tag("jan", "kowalski"));
        this.givenDescribeAnyAutoScalingInstances();
        AwsInstance instance = this.createEc2Discovery().getInstance("id-12345");
        Assertions.assertThat((List)instance.getTags()).containsOnly((Object[])new AwsResourceTag[]{AwsResourceTag.create((String)"john", (String)"doe"), AwsResourceTag.create((String)"jan", (String)"kowalski")});
    }

    private Ec2Discovery createEc2Discovery() {
        return new Ec2Discovery("mars-north-1", this.amazonEC2, this.amazonAutoScaling, new Awaitilities(), 10L);
    }

    private void givenEc2WithTwoInstances() {
        DescribeInstancesResult result = new DescribeInstancesResult();
        Reservation reservation = new Reservation();
        reservation.setInstances(Arrays.asList(new Instance().withInstanceId("i-1").withInstanceLifecycle("spot").withSpotInstanceRequestId("sir-1"), new Instance().withInstanceId("i-2").withInstanceLifecycle("spot").withSpotInstanceRequestId("sir-2")));
        result.setReservations(Collections.singletonList(reservation));
        Mockito.when((Object)this.amazonEC2.describeInstances((DescribeInstancesRequest)ArgumentMatchers.any())).thenReturn((Object)result);
    }

    private void givenAutoScalingWithTwoInstances() {
        DescribeAutoScalingInstancesResult result = new DescribeAutoScalingInstancesResult();
        result.setAutoScalingInstances(Arrays.asList(new AutoScalingInstanceDetails().withInstanceId("i-1").withLaunchConfigurationName("lc-1").withAvailabilityZone("az-1"), new AutoScalingInstanceDetails().withInstanceId("i-2").withLaunchConfigurationName("lc-2").withAvailabilityZone("az-2")));
        Mockito.when((Object)this.amazonAutoScaling.describeAutoScalingInstances((DescribeAutoScalingInstancesRequest)ArgumentMatchers.any())).thenReturn((Object)result);
    }

    private void givenSpotRequestsWithTwoInstances() {
        DescribeSpotInstanceRequestsResult result = new DescribeSpotInstanceRequestsResult().withSpotInstanceRequests(Arrays.asList(new SpotInstanceRequest().withInstanceId("i-1").withSpotInstanceRequestId("sir-1").withStatus(new SpotInstanceStatus().withUpdateTime(new Date()).withCode("pending-fulfillment")), new SpotInstanceRequest().withInstanceId("i-2").withSpotInstanceRequestId("sir-2").withStatus(new SpotInstanceStatus().withUpdateTime(new Date()).withCode("fulfilled"))));
        Mockito.when((Object)this.amazonEC2.describeSpotInstanceRequests((DescribeSpotInstanceRequestsRequest)ArgumentMatchers.any())).thenReturn((Object)result);
    }

    private void givenInstanceWithTags(String id, Tag ... tags) {
        Mockito.when((Object)this.amazonEC2.describeInstances((DescribeInstancesRequest)ArgumentMatchers.any())).thenReturn((Object)new DescribeInstancesResult().withReservations(new Reservation[]{new Reservation().withInstances(new Instance[]{new Instance().withInstanceId(id).withTags(tags)})}));
    }

    private void givenDescribeAnyInstances() {
        Mockito.when((Object)this.amazonEC2.describeInstances((DescribeInstancesRequest)ArgumentMatchers.any())).thenReturn((Object)new DescribeInstancesResult());
    }

    private void givenDescribeAnyAutoScalingInstances() {
        Mockito.when((Object)this.amazonAutoScaling.describeAutoScalingInstances((DescribeAutoScalingInstancesRequest)ArgumentMatchers.any())).thenReturn((Object)new DescribeAutoScalingInstancesResult());
    }
}

