/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersResult;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.InstanceState;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.OngoingStubbing;
import pl.codewise.commons.aws.cqrs.discovery.ClassicLoadBalancingDiscovery;
import pl.codewise.commons.aws.cqrs.model.AwsInstance;

@RunWith(value=MockitoJUnitRunner.class)
public class ClassicLoadBalancingDiscoveryTest {
    private final String loadBalancerName = "test-elb";
    @Mock
    private AmazonElasticLoadBalancing amazonElasticLoadBalancing;
    @InjectMocks
    private ClassicLoadBalancingDiscovery discovery;

    @Test
    public void shouldReportNonExistingLoadBalancer() {
        this.whenDescribeLoadBalancersRequested().thenReturn((Object)this.someResult());
        boolean result = this.discovery.hasLoadBalancer("test-elb");
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void shouldReportExistingLoadBalancer() {
        this.whenDescribeLoadBalancersRequested().thenReturn((Object)this.someResult().withLoadBalancerDescriptions(new LoadBalancerDescription[]{this.someDescription()}));
        boolean result = this.discovery.hasLoadBalancer("test-elb");
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    public void shouldCheckIfInstanceIdsAreInService() {
        this.givenTwoInstances("InService");
        boolean inService = this.discovery.areInstanceIdsInService("test-elb", Arrays.asList("i-1", "i-2"));
        Assert.assertTrue((boolean)inService);
    }

    @Test
    public void shouldCheckIfInstancesAreInService() {
        this.givenTwoInstances("InService");
        boolean inService = this.discovery.areInstancesInService("test-elb", Arrays.asList(new AwsInstance.Builder().withInstanceId("i-1").build(), new AwsInstance.Builder().withInstanceId("i-2").build()));
        Assert.assertTrue((boolean)inService);
    }

    @Test
    public void shouldCheckIfInstancesAreOutOfService() {
        this.givenTwoInstances("OutOfService");
        boolean inService = this.discovery.areInstancesOutOfService("test-elb", Arrays.asList(new AwsInstance.Builder().withInstanceId("i-1").build(), new AwsInstance.Builder().withInstanceId("i-2").build()));
        Assert.assertTrue((boolean)inService);
    }

    private void givenTwoInstances(String state) {
        DescribeInstanceHealthRequest request = new DescribeInstanceHealthRequest("test-elb").withInstances(new Instance[]{new Instance("i-1"), new Instance("i-2")});
        DescribeInstanceHealthResult result = new DescribeInstanceHealthResult().withInstanceStates(new InstanceState[]{this.instanceState("i-1", state), this.instanceState("i-2", state)});
        BDDMockito.given((Object)this.amazonElasticLoadBalancing.describeInstanceHealth(request)).willReturn((Object)result);
    }

    private InstanceState instanceState(String instanceId, String state) {
        return new InstanceState().withInstanceId(instanceId).withState(state);
    }

    private OngoingStubbing<DescribeLoadBalancersResult> whenDescribeLoadBalancersRequested() {
        return Mockito.when((Object)this.amazonElasticLoadBalancing.describeLoadBalancers(new DescribeLoadBalancersRequest().withLoadBalancerNames(new String[]{"test-elb"})));
    }

    private DescribeLoadBalancersResult someResult() {
        return new DescribeLoadBalancersResult();
    }

    private LoadBalancerDescription someDescription() {
        return new LoadBalancerDescription();
    }
}

