/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws.cqrs.discovery;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DescribeTagsRequest;
import com.amazonaws.services.autoscaling.model.DescribeTagsResult;
import com.amazonaws.services.autoscaling.model.TagDescription;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.OngoingStubbing;
import pl.codewise.commons.aws.cqrs.discovery.AutoScalingDiscovery;
import pl.codewise.commons.aws.cqrs.discovery.Ec2Discovery;
import pl.codewise.commons.aws.cqrs.model.AwsAutoScalingGroup;
import pl.codewise.commons.aws.cqrs.model.ec2.AwsAutoScalingTag;

@RunWith(value=MockitoJUnitRunner.class)
public class AutoScalingDiscoveryTest {
    private final String namePrefix = "test";
    private final Date date = Date.from(Instant.EPOCH);
    @Mock
    private Ec2Discovery ec2Discovery;
    @Mock
    private AmazonAutoScaling amazonAutoScaling;
    @InjectMocks
    private AutoScalingDiscovery autoScalingDiscovery;

    @Test
    public void shouldReturnEmptyListIfAskedAboutEmptyListOfGroupNames() {
        List groups = this.autoScalingDiscovery.getAutoScalingGroupsByNames(Collections.emptyList());
        Assertions.assertThat((List)groups).isEmpty();
    }

    @Test
    public void shouldListGroups() {
        Mockito.when((Object)this.ec2Discovery.getInstances((List)ArgumentMatchers.any())).thenReturn(null);
        List<String> groupNames = Arrays.asList("asg-1", "asg-2");
        Mockito.when((Object)this.amazonAutoScaling.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(groupNames))).thenReturn((Object)this.resultContainingGroupsWithNames("asg-1", "asg-2"));
        List groups = this.autoScalingDiscovery.getAutoScalingGroupsByNames(groupNames);
        Assertions.assertThat((List)groups).hasSameElementsAs(this.awsGroupsWithNames("asg-1", "asg-2"));
    }

    @Test
    public void shouldListGroupsWithPrefixFromSingleBatch() {
        Mockito.when((Object)this.ec2Discovery.getInstances((List)ArgumentMatchers.any())).thenReturn(null);
        this.whenDescribeAutoScalingGroupRequestedWithNextToken(null).thenReturn((Object)this.resultContainingGroupsWithNames("test1", "otherGroup", "test2"));
        List prefixedGroups = this.autoScalingDiscovery.listAutoScalingGroupsByPrefix("test");
        Assertions.assertThat((List)prefixedGroups).hasSameElementsAs(this.awsGroupsWithNames("test1", "test2"));
    }

    @Test
    public void shouldListGroupsFromConsecutiveBatches() {
        String nextToken = "abcdefgh";
        Mockito.when((Object)this.ec2Discovery.getInstances((List)ArgumentMatchers.any())).thenReturn(null);
        this.whenDescribeAutoScalingGroupRequestedWithNextToken(null).thenReturn((Object)this.resultContainingGroupsWithNames("test1", "otherGroup").withNextToken(nextToken));
        this.whenDescribeAutoScalingGroupRequestedWithNextToken(nextToken).thenReturn((Object)this.resultContainingGroupsWithNames("yetAnotherGroup", "test2"));
        List prefixedGroups = this.autoScalingDiscovery.listAutoScalingGroupsByPrefix("test");
        Assertions.assertThat((List)prefixedGroups).hasSameElementsAs(this.awsGroupsWithNames("test1", "test2"));
    }

    @Test
    public void shouldListGroupsFromMultipleBatches() {
        String nextToken1 = "abcdefgh";
        String nextToken2 = "ijklmnop";
        Mockito.when((Object)this.ec2Discovery.getInstances((List)ArgumentMatchers.any())).thenReturn(null);
        this.whenDescribeAutoScalingGroupRequestedWithNextToken(null).thenReturn((Object)this.resultContainingGroupsWithNames("otherGroup", "test1").withNextToken(nextToken1));
        this.whenDescribeAutoScalingGroupRequestedWithNextToken(nextToken1).thenReturn((Object)this.resultContainingGroupsWithNames("anotherGroup", "yetAnotherOne").withNextToken(nextToken2));
        this.whenDescribeAutoScalingGroupRequestedWithNextToken(nextToken2).thenReturn((Object)this.resultContainingGroupsWithNames("test2", "someGroup", "test3"));
        List prefixedGroups = this.autoScalingDiscovery.listAutoScalingGroupsByPrefix("test");
        Assertions.assertThat((List)prefixedGroups).hasSameElementsAs(this.awsGroupsWithNames("test1", "test2", "test3"));
    }

    @Test
    public void shouldListGroupsFilteredByTags() {
        BDDMockito.given((Object)this.amazonAutoScaling.describeTags((DescribeTagsRequest)ArgumentMatchers.any())).willReturn((Object)new DescribeTagsResult().withTags(new TagDescription[]{new TagDescription().withKey("some-fancy-tag").withValue("some-fancy-value").withResourceId("some-fancy-group-1").withPropagateAtLaunch(Boolean.valueOf(false)), new TagDescription().withResourceId("some-fancy-group-2").withKey("some-fancy-tag").withValue("some-fancy-value").withPropagateAtLaunch(Boolean.valueOf(false))}));
        List tags = this.autoScalingDiscovery.findTags("some-fancy-tag", "some-fancy-value");
        ((ListAssert)Assertions.assertThat((List)tags).hasSize(2)).containsOnly((Object[])new AwsAutoScalingTag[]{new AwsAutoScalingTag("some-fancy-group-1", "some-fancy-tag", "some-fancy-value", Boolean.valueOf(false)), new AwsAutoScalingTag("some-fancy-group-2", "some-fancy-tag", "some-fancy-value", Boolean.valueOf(false))});
    }

    private OngoingStubbing<DescribeAutoScalingGroupsResult> whenDescribeAutoScalingGroupRequestedWithNextToken(String nextToken) {
        return Mockito.when((Object)this.amazonAutoScaling.describeAutoScalingGroups(new DescribeAutoScalingGroupsRequest().withNextToken(nextToken)));
    }

    private DescribeAutoScalingGroupsResult resultContainingGroupsWithNames(String ... groupNames) {
        List autoScalingGroups = Arrays.stream(groupNames).map(this::groupWithName).collect(Collectors.toList());
        return new DescribeAutoScalingGroupsResult().withAutoScalingGroups(autoScalingGroups);
    }

    private AutoScalingGroup groupWithName(String groupName) {
        return new AutoScalingGroup().withAutoScalingGroupName(groupName).withCreatedTime(this.date);
    }

    private List<AwsAutoScalingGroup> awsGroupsWithNames(String ... groupNames) {
        return Arrays.stream(groupNames).map(groupName -> new AwsAutoScalingGroup.Builder().withAutoScalingGroupName(groupName).withCreated(this.date).withLoadBalancerNames(Collections.emptyList()).build()).collect(Collectors.toList());
    }
}

