/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws;

import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import pl.codewise.commons.aws.IpAddressValidator;

@RunWith(value=JUnitParamsRunner.class)
public class IpAddressValidatorTest {
    private static final IpAddressValidator IP_ADDRESS_VALIDATOR = new IpAddressValidator();

    public Object[] validIPV4Addresses() {
        return new Object[]{"1.1.1.1", "128.200.233.11", "255.255.255.255", "0.0.0.0"};
    }

    public Object[] invalidIPV4Addresses() {
        return new Object[]{"1.1.1.", "128.200.233.256", "something", "fe80:0000:0000:0000:0202:b3gf:fe1e:8329", "1.1.1.1..", "-1", "123"};
    }

    public Object[] validIPV6Addresses() {
        return new Object[]{"fe80:0000:0000:0000:0202:b3ff:fe1e:8329", "fe80::202:b3ff:fe1e:8329", "FE80::0202:B3FF:FE1E:8329", "::ffff:123.45.67.89"};
    }

    public Object[] invalidIPV6Addresses() {
        return new Object[]{"fe80:0000:0000:0000:0202:b3ff:fe1e:8329-", "fe80:0000:0000:0000:0202:b3ff:fe1e:8329:111", "fe80::202:b3ff:fe1e:8329::123", "FE80::0202:B3FF:FE1E:8329:k123", "FE80::0202::B3FF::FE1E::8329", "::::"};
    }

    @Test
    @Parameters(method="validIPV4Addresses")
    public void shouldHandleValidIpv4(String ipv4) {
        boolean valid1 = IP_ADDRESS_VALIDATOR.isValid(ipv4);
        boolean valid2 = IP_ADDRESS_VALIDATOR.isValidIPV4(ipv4);
        Assertions.assertThat((boolean)valid1).isTrue();
        Assertions.assertThat((boolean)valid2).isTrue();
    }

    @Test
    @Parameters(method="invalidIPV4Addresses")
    public void shouldHandleInvalidIpv4Address(String ipv4) {
        boolean invalid1 = IP_ADDRESS_VALIDATOR.isValid(ipv4);
        boolean invalid2 = IP_ADDRESS_VALIDATOR.isValidIPV4(ipv4);
        Assertions.assertThat((boolean)invalid1).isFalse();
        Assertions.assertThat((boolean)invalid2).isFalse();
    }

    @Test
    @Parameters(method="validIPV6Addresses")
    public void shouldHandleValidIpv6(String ip) {
        boolean valid1 = IP_ADDRESS_VALIDATOR.isValid(ip);
        boolean valid2 = IP_ADDRESS_VALIDATOR.isValidIPV4(ip);
        Assertions.assertThat((boolean)valid1).isTrue();
        Assertions.assertThat((boolean)valid2).isFalse();
    }

    @Test
    @Parameters(method="invalidIPV6Addresses")
    public void shouldHandleInvalidIpv6(String ip) {
        boolean valid1 = IP_ADDRESS_VALIDATOR.isValid(ip);
        boolean valid2 = IP_ADDRESS_VALIDATOR.isValidIPV4(ip);
        Assertions.assertThat((boolean)valid1).isFalse();
        Assertions.assertThat((boolean)valid2).isFalse();
    }

    @Test
    public void shouldHandleValidIpv4OverIpv6() {
        boolean valid = IP_ADDRESS_VALIDATOR.isValid("::ffff:123.45.67.89");
        Assertions.assertThat((boolean)valid).isTrue();
    }
}

