/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws;

import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import pl.codewise.commons.aws.Ec2Wrapper;
import pl.codewise.commons.aws.InstanceNameUpdater;
import pl.codewise.commons.aws.IpProvider;
import pl.codewise.commons.aws.Sleeper;

public class InstanceNameUpdaterTest {
    private static final String THIS_IP = "123.123.123.123";
    private static final String SOME_IP_ADDRESS = "222.222.222.222";
    private static final String FIRST_AUTO_SCALING_GROUP = "service-1";
    private static final String SECOND_AUTO_SCALING_GROUP = "service-2";
    private static final List<String> AUTO_SCALING_GROUPS = Arrays.asList("service-1", "service-2");
    private static final String INSTANCE_PREFIX = "instance-";
    private IpProvider ipProvider = () -> "123.123.123.123";
    private Ec2Wrapper ec2Wrapper = (Ec2Wrapper)Mockito.mock(Ec2Wrapper.class);
    private Map<String, List<Instance>> configuredInstances = new HashMap<String, List<Instance>>();
    private Map<String, List<Instance>> collisionCheckInstances = new HashMap<String, List<Instance>>();
    private Map<String, List<Instance>> finalInstances = new HashMap<String, List<Instance>>();
    private Sleeper sleeper = (Sleeper)Mockito.mock(Sleeper.class);
    private InstanceNameUpdater instanceNameUpdater = new InstanceNameUpdater(this.ipProvider, "instance-", this.ec2Wrapper, AUTO_SCALING_GROUPS, this.sleeper);

    @Before
    public void setUp() {
        AUTO_SCALING_GROUPS.forEach(group -> {
            this.configuredInstances.put((String)group, new ArrayList());
            this.collisionCheckInstances.put((String)group, new ArrayList());
            this.finalInstances.put((String)group, new ArrayList());
            BDDMockito.given((Object)this.ec2Wrapper.describeInstances(group)).willReturn(this.configuredInstances.get(group), (Object[])new List[]{this.collisionCheckInstances.get(group), this.finalInstances.get(group)});
        });
    }

    @Test
    public void shouldSetNameAsFirstFreeNumber() {
        Instance someOtherInstance = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "instance-2")});
        Instance completelyDifferentInstance = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "otherInstance-1")});
        Instance thisMachine = new Instance().withPublicIpAddress(THIS_IP).withTags(Collections.emptyList());
        this.addAlreadyConfiguredInstances(FIRST_AUTO_SCALING_GROUP, someOtherInstance, completelyDifferentInstance, thisMachine);
        Instance instanceInOtherGroup = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "instance-3")});
        this.addAlreadyConfiguredInstances(SECOND_AUTO_SCALING_GROUP, instanceInOtherGroup);
        String instanceName = this.instanceNameUpdater.updateEc2InstanceName();
        Assertions.assertThat((String)instanceName).isEqualTo((Object)"instance-1");
        ((Ec2Wrapper)Mockito.verify((Object)this.ec2Wrapper)).setInstanceName(thisMachine, "instance-1");
        ((Sleeper)Mockito.verify((Object)this.sleeper)).sleep();
    }

    @Test
    public void shouldCorrectlySetFirstFreeNumberIfInstanceNumberInvalid() {
        Instance otherInstance = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "instance--3")});
        Instance thisMachine = new Instance().withPublicIpAddress(THIS_IP).withTags(Collections.emptyList());
        this.addAlreadyConfiguredInstances(FIRST_AUTO_SCALING_GROUP, otherInstance, thisMachine);
        Instance instanceInOtherGroup = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "instance--")});
        this.addAlreadyConfiguredInstances(SECOND_AUTO_SCALING_GROUP, instanceInOtherGroup);
        String instanceName = this.instanceNameUpdater.updateEc2InstanceName();
        Assertions.assertThat((String)instanceName).isEqualTo((Object)"instance-1");
        ((Ec2Wrapper)Mockito.verify((Object)this.ec2Wrapper)).setInstanceName(thisMachine, "instance-1");
        ((Sleeper)Mockito.verify((Object)this.sleeper)).sleep();
    }

    @Test
    public void shouldSetNameAsFirstFreeNumberWhenFirstPossibleOptionIsNotAvailable() {
        Instance otherInstance = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "instance-1")});
        Instance otherInstance2 = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "instance-3")});
        Instance completelyDifferentInstance = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "otherInstance-1")});
        Instance thisMachine = new Instance().withPublicIpAddress(THIS_IP).withTags(Collections.emptyList());
        this.addAlreadyConfiguredInstances(FIRST_AUTO_SCALING_GROUP, otherInstance, otherInstance2, completelyDifferentInstance, thisMachine);
        Instance instanceInOtherGroup = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "instance-2")});
        this.addAlreadyConfiguredInstances(SECOND_AUTO_SCALING_GROUP, instanceInOtherGroup);
        String instanceName = this.instanceNameUpdater.updateEc2InstanceName();
        Assertions.assertThat((String)instanceName).isEqualTo((Object)"instance-4");
        ((Ec2Wrapper)Mockito.verify((Object)this.ec2Wrapper)).setInstanceName(thisMachine, "instance-4");
        ((Sleeper)Mockito.verify((Object)this.sleeper)).sleep();
    }

    @Test
    public void shouldSetNameOfInstanceWithThisMachinesIpWhenNoOtherOfThisKindExists() {
        Instance completelyDifferentInstance = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "otherInstance-")});
        Instance thisMachine = new Instance().withPublicIpAddress(THIS_IP).withTags(Collections.emptyList());
        this.addAlreadyConfiguredInstances(FIRST_AUTO_SCALING_GROUP, completelyDifferentInstance, thisMachine);
        Instance instanceInOtherGroup = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "otherInstance-2")});
        this.addAlreadyConfiguredInstances(SECOND_AUTO_SCALING_GROUP, instanceInOtherGroup);
        String instanceName = this.instanceNameUpdater.updateEc2InstanceName();
        Assertions.assertThat((String)instanceName).isEqualTo((Object)"instance-1");
        ((Ec2Wrapper)Mockito.verify((Object)this.ec2Wrapper)).setInstanceName(thisMachine, "instance-1");
        ((Sleeper)Mockito.verify((Object)this.sleeper)).sleep();
    }

    @Test
    public void shouldRetryInCaseOfNameCollisionInSameAutoScalingGroup() {
        Instance someOtherInstance = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "instance-1")});
        Instance collidingInstance = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "instance-2")});
        Instance thisMachine = new Instance().withPublicIpAddress(THIS_IP).withTags(Collections.emptyList());
        Instance thisMachineAfterUpdate = new Instance().withPublicIpAddress("123.132").withTags(new Tag[]{new Tag("Name", "instance-2")});
        this.addAlreadyConfiguredInstances(FIRST_AUTO_SCALING_GROUP, someOtherInstance, thisMachine);
        this.addCollidingInstances(FIRST_AUTO_SCALING_GROUP, collidingInstance, thisMachineAfterUpdate);
        String instanceName = this.instanceNameUpdater.updateEc2InstanceName();
        Assertions.assertThat((String)instanceName).isEqualTo((Object)"instance-3");
        ((Ec2Wrapper)Mockito.verify((Object)this.ec2Wrapper)).setInstanceName(thisMachine, "instance-2");
        ((Ec2Wrapper)Mockito.verify((Object)this.ec2Wrapper)).setInstanceName(thisMachine, "instance-3");
        ((Sleeper)Mockito.verify((Object)this.sleeper, (VerificationMode)Mockito.times((int)2))).sleep();
    }

    @Test
    public void shouldRetryInCaseOfNameCollisionInDifferentAutoScalingGroup() {
        Instance someOtherInstance = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "instance-1")});
        Instance collidingInstance = new Instance().withPublicIpAddress(SOME_IP_ADDRESS).withTags(new Tag[]{new Tag("Name", "instance-2")});
        Instance thisMachine = new Instance().withPublicIpAddress(THIS_IP).withTags(Collections.emptyList());
        Instance thisMachineAfterUpdate = new Instance().withPublicIpAddress("123.132").withTags(new Tag[]{new Tag("Name", "instance-2")});
        this.addAlreadyConfiguredInstances(FIRST_AUTO_SCALING_GROUP, someOtherInstance, thisMachine);
        this.addCollidingInstances(FIRST_AUTO_SCALING_GROUP, thisMachineAfterUpdate);
        this.addCollidingInstances(SECOND_AUTO_SCALING_GROUP, collidingInstance);
        String instanceName = this.instanceNameUpdater.updateEc2InstanceName();
        Assertions.assertThat((String)instanceName).isEqualTo((Object)"instance-3");
        ((Ec2Wrapper)Mockito.verify((Object)this.ec2Wrapper)).setInstanceName(thisMachine, "instance-2");
        ((Ec2Wrapper)Mockito.verify((Object)this.ec2Wrapper)).setInstanceName(thisMachine, "instance-3");
        ((Sleeper)Mockito.verify((Object)this.sleeper, (VerificationMode)Mockito.times((int)2))).sleep();
    }

    private void addAlreadyConfiguredInstances(String autoScalingGroup, Instance ... instances) {
        for (Instance instance : instances) {
            this.configuredInstances.get(autoScalingGroup).add(instance);
            this.collisionCheckInstances.get(autoScalingGroup).add(instance);
            this.finalInstances.get(autoScalingGroup).add(instance);
        }
    }

    private void addCollidingInstances(String autoScalingGroup, Instance ... instances) {
        for (Instance instance : instances) {
            this.collisionCheckInstances.get(autoScalingGroup).add(instance);
            this.finalInstances.get(autoScalingGroup).add(instance);
        }
    }
}

