/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import pl.codewise.commons.aws.EnvironmentAwareProviderFactory;
import pl.codewise.commons.aws.IdProvider;
import pl.codewise.commons.aws.IpProvider;
import pl.codewise.commons.aws.IpResolutionException;
import pl.codewise.commons.aws.RegionProvider;
import pl.codewise.commons.aws.ZoneProvider;

public class EnvironmentAwareProviderFactoryTest {
    @Test
    public void shouldReturnUnknownZoneIfNotOnAmazonEnvironment() {
        ZoneProvider provider = EnvironmentAwareProviderFactory.create((ZoneProvider)((ZoneProvider)Mockito.mock(ZoneProvider.class)), (boolean)false);
        Assertions.assertThat((String)provider.getAvailabilityZone()).contains(new CharSequence[]{"unknown"});
    }

    @Test
    public void shouldReturnAmazonZoneWhenOnAmazonEnvironment() throws IpResolutionException {
        ZoneProvider amazonZoneProvider = (ZoneProvider)Mockito.mock(ZoneProvider.class);
        BDDMockito.given((Object)amazonZoneProvider.getAvailabilityZone()).willReturn((Object)"us-east-1");
        ZoneProvider provider = EnvironmentAwareProviderFactory.create((ZoneProvider)amazonZoneProvider, (boolean)true);
        Assertions.assertThat((String)provider.getAvailabilityZone()).isEqualTo((Object)"us-east-1");
    }

    @Test
    public void shouldReturnUnknownRegionIfNotOnAmazonEnvironment() {
        RegionProvider provider = EnvironmentAwareProviderFactory.create((RegionProvider)((RegionProvider)Mockito.mock(RegionProvider.class)), (boolean)false);
        Assertions.assertThat((String)provider.getRegion()).contains(new CharSequence[]{"unknown"});
    }

    @Test
    public void shouldReturnAmazonRegionWhenOnAmazonEnvironment() throws IpResolutionException {
        RegionProvider amazonRegionProvider = (RegionProvider)Mockito.mock(RegionProvider.class);
        BDDMockito.given((Object)amazonRegionProvider.getRegion()).willReturn((Object)"us-east-1");
        RegionProvider provider = EnvironmentAwareProviderFactory.create((RegionProvider)amazonRegionProvider, (boolean)true);
        Assertions.assertThat((String)provider.getRegion()).isEqualTo((Object)"us-east-1");
    }

    @Test
    public void shouldReturnLocalhostIfNotOnAmazonEnvironment() throws IpResolutionException {
        IpProvider provider = EnvironmentAwareProviderFactory.create((IpProvider)((IpProvider)Mockito.mock(IpProvider.class)), (boolean)false);
        Assertions.assertThat((String)provider.getIp()).isEqualTo((Object)"127.0.0.1");
    }

    @Test
    public void shouldReturnAmazonIpWhenOnAmazonEnvironment() throws IpResolutionException {
        IpProvider amazonIpProvider = (IpProvider)Mockito.mock(IpProvider.class);
        BDDMockito.given((Object)amazonIpProvider.getIp()).willReturn((Object)"3.14.15.92");
        IpProvider provider = EnvironmentAwareProviderFactory.create((IpProvider)amazonIpProvider, (boolean)true);
        Assertions.assertThat((String)provider.getIp()).isEqualTo((Object)"3.14.15.92");
    }

    @Test
    public void shouldReturnNoIdIfNotOnAmazonEnvironment() throws IpResolutionException {
        IdProvider provider = EnvironmentAwareProviderFactory.create((IdProvider)((IdProvider)Mockito.mock(IdProvider.class)), (boolean)false);
        Assertions.assertThat((String)provider.getInstanceId()).isEqualTo((Object)"unknown_box");
    }

    @Test
    public void shouldReturnAmazonIdWhenOnAmazonEnvironment() throws IpResolutionException {
        IdProvider amazonIdProvider = (IdProvider)Mockito.mock(IdProvider.class);
        BDDMockito.given((Object)amazonIdProvider.getInstanceId()).willReturn((Object)"instance-id");
        IdProvider provider = EnvironmentAwareProviderFactory.create((IdProvider)amazonIdProvider, (boolean)true);
        Assertions.assertThat((String)provider.getInstanceId()).isEqualTo((Object)"instance-id");
    }
}

