/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeTagsRequest;
import com.amazonaws.services.ec2.model.DescribeTagsResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.TagDescription;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import pl.codewise.commons.aws.AwsEc2Instance;
import pl.codewise.commons.aws.EC2InstanceNameProvider;
import pl.codewise.commons.aws.FakeAwsEc2Instance;

public class EC2InstanceNameProviderTest {
    private AmazonEC2 amazonEC2 = (AmazonEC2)Mockito.mock(AmazonEC2.class);
    private AwsEc2Instance awsEc2Instance = FakeAwsEc2Instance.INSTANCE;
    private EC2InstanceNameProvider ec2InstanceNameProvider = new EC2InstanceNameProvider(this.amazonEC2, this.awsEc2Instance);

    @Test
    public void shouldGetInstanceName() {
        BDDMockito.given((Object)this.amazonEC2.describeTags(new DescribeTagsRequest().withFilters(new Filter[]{new Filter().withName("resource-id").withValues(new String[]{this.awsEc2Instance.getInstanceId()})}))).willReturn((Object)new DescribeTagsResult().withTags(new TagDescription[]{new TagDescription().withKey("name").withValue("instance-name")}));
        String name = this.ec2InstanceNameProvider.getInstanceName();
        Assertions.assertThat((String)name).isEqualTo((Object)"instance-name");
    }
}

