/*
 * Decompiled with CFR 0.152.
 */
package pl.codewise.commons.aws;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import pl.codewise.commons.aws.AwsEc2Instance;
import pl.codewise.commons.aws.EC2InstanceIpProvider;
import pl.codewise.commons.aws.IpResolutionException;

public class EC2InstanceIpProviderTest {
    private AwsEc2Instance awsEc2Instance = (AwsEc2Instance)Mockito.mock(AwsEc2Instance.class);
    private EC2InstanceIpProvider ipProvider = new EC2InstanceIpProvider(this.awsEc2Instance);

    @Test
    public void shouldReturnValidIpAddress() throws IpResolutionException {
        String validIp = "144.33.18.245";
        BDDMockito.given((Object)this.awsEc2Instance.getInstanceIp()).willReturn((Object)validIp);
        String ip = this.ipProvider.getIp();
        Assertions.assertThat((String)ip).isEqualTo((Object)validIp);
    }

    @Test(expected=IpResolutionException.class)
    public void shouldThrowIpResolutionExceptionWhenReturnedIpIsNotValid() throws IpResolutionException {
        BDDMockito.given((Object)this.awsEc2Instance.getInstanceIp()).willReturn((Object)"144.33.1s8.245");
        this.ipProvider.getIp();
    }
}

