package pl.codewise.commons.aws.cqrs.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileSystem {

    public Path createTempFileWithText(String key, String text) throws IOException {
        String prefix = key.replace('/', '-');
        Path tempPath = Files.createTempFile(prefix, "");
        Files.write(tempPath, text.getBytes());
        return tempPath;
    }

    public void deleteFileIfExists(Path path) {
        try {
            if (path != null && Files.exists(path)) {
                Files.deleteIfExists(path);
            }
        } catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}
