package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.PublishVersionRequest;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;

import java.nio.ByteBuffer;

public class LambdaOperations {

    private final AWSLambda awsLambda;

    public LambdaOperations(AWSLambda awsLambda) {
        this.awsLambda = awsLambda;
    }

    public void uploadLambda(String functionName, ByteBuffer zipFile, String description) {
        awsLambda.updateFunctionCode(new UpdateFunctionCodeRequest()
                .withFunctionName(functionName)
                .withZipFile(zipFile));
        awsLambda.publishVersion(new PublishVersionRequest()
                .withFunctionName(functionName)
                .withDescription(description));
    }
}
