package pl.codewise.commons.aws.cqrs.operations;

import com.amazonaws.services.autoscaling.model.Alarm;
import com.amazonaws.services.autoscaling.model.ScalingPolicy;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest;
import com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.codewise.commons.aws.cqrs.model.AwsScalingPolicies;

import java.util.List;
import java.util.stream.Collectors;

public class CloudWatchOperations {

    private static final Logger log = LoggerFactory.getLogger(CloudWatchOperations.class);

    private final AmazonCloudWatch amazonCloudWatch;

    public CloudWatchOperations(AmazonCloudWatch amazonCloudWatch) {
        this.amazonCloudWatch = amazonCloudWatch;
    }

    public void disableAlarms(AwsScalingPolicies awsScalingPolicies) {
        awsScalingPolicies.getPolicies()
                .stream()
                .peek(policy -> log.info("Disable alarms for policy: {}", policy))
                .forEach(this::disableAlarms);
    }

    public void disableAlarms(ScalingPolicy scalingPolicy) {
        amazonCloudWatch.disableAlarmActions(new DisableAlarmActionsRequest()
                .withAlarmNames(toAlarmNames(scalingPolicy)));
    }

    public void enableAlarms(AwsScalingPolicies awsScalingPolicies) {
        awsScalingPolicies.getPolicies()
                .stream()
                .peek(policy -> log.info("Enable alarms for policy: {}", policy))
                .forEach(this::enableAlarms);
    }

    public void enableAlarms(ScalingPolicy scalingPolicy) {
        amazonCloudWatch.enableAlarmActions(new EnableAlarmActionsRequest()
                .withAlarmNames(toAlarmNames(scalingPolicy)));
    }

    private List<String> toAlarmNames(ScalingPolicy scalingPolicy) {
        return scalingPolicy.getAlarms().stream()
                .map(Alarm::getAlarmName)
                .collect(Collectors.toList());
    }
}
