package pl.codewise.commons.aws.cqrs.model.s3;

import com.google.common.base.MoreObjects;
import pl.codewise.commons.aws.cqrs.model.AwsResource;
import pl.codewise.commons.aws.cqrs.model.AwsResourceVisitor;

import java.util.Objects;

public class AwsS3Object implements AwsResource {

    private final String bucket;
    private final String key;

    public AwsS3Object(String bucket, String key) {
        this.bucket = bucket;
        this.key = key;
    }

    public static AwsS3Object in(String bucket, String key) {
        return new AwsS3Object(bucket, key);
    }

    public String getKey() {
        return key;
    }

    public String getBucket() {
        return bucket;
    }

    @Override
    public String getId() {
        return String.join("/", bucket, key);
    }

    @Override
    public void accept(AwsResourceVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsS3Object that = (AwsS3Object) o;
        return Objects.equals(bucket, that.bucket) &&
                Objects.equals(key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(bucket, key);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("bucket", bucket)
                .add("key", key)
                .toString();
    }
}
