package pl.codewise.commons.aws.cqrs.model.route53;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class AwsResourceRecord {

    private final String value;

    public AwsResourceRecord(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsResourceRecord that = (AwsResourceRecord) o;
        return Objects.equal(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(value);
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    public String getValue() {
        return value;
    }

    public static class Builder {

        private String value;

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public AwsResourceRecord build() {
            return new AwsResourceRecord(value);
        }
    }
}
