package pl.codewise.commons.aws.cqrs.model.route53;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class AwsRegisterDomainRequest {

    private final String domainName;
    private final boolean autoRenew;
    private final int durationYears;
    private final boolean protectAdminContact;
    private final boolean protectRegistrantContact;
    private final boolean protectTechContact;
    private final AwsContactDetails adminContact;
    private final AwsContactDetails registrantContact;
    private final AwsContactDetails techContact;

    private AwsRegisterDomainRequest(String domainName, boolean autoRenew, int durationYears,
            boolean protectAdminContact, boolean protectRegistrantContact, boolean protectTechContact,
            AwsContactDetails adminContact,
            AwsContactDetails registrantContact,
            AwsContactDetails techContact) {
        this.domainName = domainName;
        this.autoRenew = autoRenew;
        this.durationYears = durationYears;
        this.protectAdminContact = protectAdminContact;
        this.protectRegistrantContact = protectRegistrantContact;
        this.protectTechContact = protectTechContact;
        this.adminContact = adminContact;
        this.registrantContact = registrantContact;
        this.techContact = techContact;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsRegisterDomainRequest that = (AwsRegisterDomainRequest) o;
        return autoRenew == that.autoRenew &&
                durationYears == that.durationYears &&
                protectAdminContact == that.protectAdminContact &&
                protectRegistrantContact == that.protectRegistrantContact &&
                protectTechContact == that.protectTechContact &&
                Objects.equal(domainName, that.domainName) &&
                Objects.equal(adminContact, that.adminContact) &&
                Objects.equal(registrantContact, that.registrantContact) &&
                Objects.equal(techContact, that.techContact);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(domainName, autoRenew, durationYears, protectAdminContact, protectRegistrantContact,
                protectTechContact, adminContact, registrantContact, techContact);
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    public String getDomainName() {
        return domainName;
    }

    public boolean isAutoRenew() {
        return autoRenew;
    }

    public int getDurationYears() {
        return durationYears;
    }

    public boolean isProtectAdminContact() {
        return protectAdminContact;
    }

    public boolean isProtectRegistrantContact() {
        return protectRegistrantContact;
    }

    public boolean isProtectTechContact() {
        return protectTechContact;
    }

    public AwsContactDetails getAdminContact() {
        return adminContact;
    }

    public AwsContactDetails getRegistrantContact() {
        return registrantContact;
    }

    public AwsContactDetails getTechContact() {
        return techContact;
    }

    public static class Builder {

        private String domainName;
        private boolean autoRenew;
        private int durationYears;
        private boolean protectAdminContact;
        private boolean protectRegistrantContact;
        private boolean protectTechContact;
        private AwsContactDetails adminContact;
        private AwsContactDetails registrantContact;
        private AwsContactDetails techContact;

        public Builder withDomainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder withAutoRenew(boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public Builder withDurationYears(int durationYears) {
            this.durationYears = durationYears;
            return this;
        }

        public Builder withProtectAdminContact(boolean protectAdminContact) {
            this.protectAdminContact = protectAdminContact;
            return this;
        }

        public Builder withProtectRegistrantContact(boolean protectRegistrantContact) {
            this.protectRegistrantContact = protectRegistrantContact;
            return this;
        }

        public Builder withProtectTechContact(boolean protectTechContact) {
            this.protectTechContact = protectTechContact;
            return this;
        }

        public Builder withAdminContact(AwsContactDetails adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public Builder withRegistrantContact(AwsContactDetails registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public Builder withTechContact(AwsContactDetails techContact) {
            this.techContact = techContact;
            return this;
        }

        public AwsRegisterDomainRequest build() {
            return new AwsRegisterDomainRequest(
                    domainName,
                    autoRenew,
                    durationYears,
                    protectAdminContact,
                    protectRegistrantContact,
                    protectTechContact,
                    adminContact,
                    registrantContact,
                    techContact);
        }
    }
}
