package pl.codewise.commons.aws.cqrs.model.route53;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import java.util.List;

public class AwsRecordSet {

    private final String name;
    private final String type;
    private final String region;
    private final Long ttl;
    private final String setIdentifier;
    private final AwsAliasTarget aliasTarget;
    private final Boolean multiValueAnswer;
    private final String healthCheckId;
    private final List<AwsResourceRecord> resourceRecords;

    public AwsRecordSet(String name, String type, String region, Long ttl, String setIdentifier,
            AwsAliasTarget aliasTarget, Boolean multiValueAnswer, String healthCheckId,
            List<AwsResourceRecord> resourceRecords) {
        this.name = name;
        this.type = type;
        this.region = region;
        this.ttl = ttl;
        this.setIdentifier = setIdentifier;
        this.aliasTarget = aliasTarget;
        this.multiValueAnswer = multiValueAnswer;
        this.healthCheckId = healthCheckId;
        this.resourceRecords = resourceRecords;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsRecordSet that = (AwsRecordSet) o;
        return Objects.equal(name, that.name) &&
                Objects.equal(type, that.type) &&
                Objects.equal(region, that.region) &&
                Objects.equal(ttl, that.ttl) &&
                Objects.equal(setIdentifier, that.setIdentifier) &&
                Objects.equal(aliasTarget, that.aliasTarget) &&
                Objects.equal(multiValueAnswer, that.multiValueAnswer) &&
                Objects.equal(resourceRecords, that.resourceRecords);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(name, type, region, ttl, setIdentifier, aliasTarget, multiValueAnswer, resourceRecords);
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    public String getName() {
        return name;
    }

    public String getType() {
        return type;
    }

    public String getRegion() {
        return region;
    }

    public Long getTtl() {
        return ttl;
    }

    public String getSetIdentifier() {
        return setIdentifier;
    }

    public AwsAliasTarget getAliasTarget() {
        return aliasTarget;
    }

    public Boolean getMultiValueAnswer() {
        return multiValueAnswer;
    }

    public String getHealthCheckId() {
        return healthCheckId;
    }

    public List<AwsResourceRecord> getResourceRecords() {
        return resourceRecords;
    }

    public static class Builder {

        private String name;
        private String type;
        private String region;
        private Long ttl;
        private String setIdentifier;
        private AwsAliasTarget aliasTarget;
        private Boolean multiValueAnswer;
        private String healthCheckId;
        private List<AwsResourceRecord> resourceRecords;

        public Builder() {
        }

        public Builder(AwsRecordSet awsRecordSet) {
            name = awsRecordSet.name;
            type = awsRecordSet.type;
            region = awsRecordSet.region;
            ttl = awsRecordSet.ttl;
            setIdentifier = awsRecordSet.setIdentifier;
            aliasTarget = awsRecordSet.aliasTarget;
            multiValueAnswer = awsRecordSet.multiValueAnswer;
            healthCheckId = awsRecordSet.healthCheckId;
            resourceRecords = awsRecordSet.resourceRecords;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder withTtl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder withSetIdentifier(String setIdentifier) {
            this.setIdentifier = setIdentifier;
            return this;
        }

        public Builder withAliasTarget(AwsAliasTarget aliasTarget) {
            this.aliasTarget = aliasTarget;
            return this;
        }

        public Builder withMultiValueAnswer(Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
            return this;
        }

        public Builder withHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public Builder withResourceRecords(List<AwsResourceRecord> resourceRecords) {
            this.resourceRecords = resourceRecords;
            return this;
        }

        public AwsRecordSet build() {
            return new AwsRecordSet(
                    name,
                    type,
                    region,
                    ttl,
                    setIdentifier,
                    aliasTarget,
                    multiValueAnswer,
                    healthCheckId,
                    resourceRecords);
        }
    }
}
