package pl.codewise.commons.aws.cqrs.model.route53;

import com.google.common.base.Objects;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class AwsAliasTarget {

    private String hostedZoneId;
    private String dnsName;
    private Boolean evaluateTargetHealth;

    public AwsAliasTarget(String hostedZoneId, String dnsName, Boolean evaluateTargetHealth) {
        this.hostedZoneId = hostedZoneId;
        this.dnsName = dnsName;
        this.evaluateTargetHealth = evaluateTargetHealth;
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsAliasTarget that = (AwsAliasTarget) o;
        return Objects.equal(hostedZoneId, that.hostedZoneId) &&
                Objects.equal(dnsName, that.dnsName) &&
                Objects.equal(evaluateTargetHealth, that.evaluateTargetHealth);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(hostedZoneId, dnsName, evaluateTargetHealth);
    }

    public String getHostedZoneId() {
        return hostedZoneId;
    }

    public String getDnsName() {
        return dnsName;
    }

    public Boolean getEvaluateTargetHealth() {
        return evaluateTargetHealth;
    }

    public static class Builder {

        private String hostedZoneId;
        private String dnsName;
        private Boolean evaluateTargetHealth;

        public Builder withHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public Builder withDnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public Builder withEvaluateTargetHealth(Boolean evaluateTargetHealth) {
            this.evaluateTargetHealth = evaluateTargetHealth;
            return this;
        }

        public AwsAliasTarget build() {
            return new AwsAliasTarget(hostedZoneId, dnsName, evaluateTargetHealth);
        }
    }
}
