package pl.codewise.commons.aws.cqrs.model.ec2.spot;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import java.util.Date;
import java.util.Objects;

public class AwsSpotRequestDetails {

    private final String requestId;
    private final String status;
    private final Date statusUpdateTime;
    private final String productDescription;

    public AwsSpotRequestDetails(String requestId, String status, Date statusUpdateTime, String productDescription) {
        this.requestId = requestId;
        this.status = status;
        this.statusUpdateTime = statusUpdateTime;
        this.productDescription = productDescription;
    }

    public String getRequestId() {
        return requestId;
    }

    public String getStatus() {
        return status;
    }

    public Date getStatusUpdateTime() {
        return statusUpdateTime;
    }

    public String getProductDescription() {
        return productDescription;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsSpotRequestDetails that = (AwsSpotRequestDetails) o;
        return Objects.equals(requestId, that.requestId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(requestId);
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    public static class Builder {

        private String requestId;
        private String status;
        private Date statusUpdateTime;
        private String productDescription;

        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withStatusUpdateTime(Date updateTime) {
            this.statusUpdateTime = updateTime;
            return this;
        }

        public Builder withProductDescription(String description) {
            this.productDescription = description;
            return this;
        }


        public AwsSpotRequestDetails build() {
            return new AwsSpotRequestDetails(requestId, status, statusUpdateTime, productDescription);
        }
    }
}
