package pl.codewise.commons.aws.cqrs.model.ec2.sg;

import com.google.common.base.MoreObjects;
import pl.codewise.commons.aws.cqrs.model.AwsResource;
import pl.codewise.commons.aws.cqrs.model.AwsResourceVisitor;

import java.util.Objects;

public class AwsSecurityGroup implements AwsResource {

    private final String groupId;
    private String groupName;
    private String vpcId;

    public AwsSecurityGroup(String groupId) {
        this.groupId = groupId;
    }

    public AwsSecurityGroup withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public AwsSecurityGroup withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getVpcId() {
        return vpcId;
    }

    @Override
    public String getId() {
        return groupId;
    }

    @Override
    public void accept(AwsResourceVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsSecurityGroup that = (AwsSecurityGroup) o;
        return Objects.equals(groupId, that.groupId) &&
                Objects.equals(groupName, that.groupName) &&
                Objects.equals(vpcId, that.vpcId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(groupId, groupName, vpcId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("groupId", groupId)
                .add("groupName", groupName)
                .add("vpcId", vpcId)
                .toString();
    }
}
