package pl.codewise.commons.aws.cqrs.model.ec2.autoscaling;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import java.util.Objects;

public class AwsAutoScalingDetails {

    private final String launchConfigurationName;
    private final String availabilityZone;
    private final String lifecycleState;

    private AwsAutoScalingDetails(String launchConfigurationName, String availabilityZone, String lifecycleState) {
        this.launchConfigurationName = launchConfigurationName;
        this.availabilityZone = availabilityZone;
        this.lifecycleState = lifecycleState;
    }

    public String getLaunchConfigurationName() {
        return launchConfigurationName;
    }

    public String getAvailabilityZone() {
        return availabilityZone;
    }

    public String getLifecycleState() {
        return lifecycleState;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsAutoScalingDetails that = (AwsAutoScalingDetails) o;
        return Objects.equals(launchConfigurationName, that.launchConfigurationName) &&
                Objects.equals(availabilityZone, that.availabilityZone) &&
                Objects.equals(lifecycleState, that.lifecycleState);
    }

    @Override
    public int hashCode() {
        return Objects.hash(launchConfigurationName, availabilityZone, lifecycleState);
    }

    @Override
    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    public static class Builder {

        private String launchConfigurationName;
        private String availabilityZone;
        private String lifecycleState;

        public Builder withLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public Builder withAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Builder withLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public AwsAutoScalingDetails build() {
            return new AwsAutoScalingDetails(launchConfigurationName, availabilityZone, lifecycleState);
        }
    }
}
