package pl.codewise.commons.aws.cqrs.model.ec2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class LoadBalancerParameters {

    private final String name;
    private final Collection<AwsLoadBalancerListener> listeners;
    private final Collection<String> subnets;
    private final Collection<String> securityGroups;
    private final boolean internal;
    private final Collection<AwsResourceTag> tags;

    private LoadBalancerParameters(String name, Collection<AwsLoadBalancerListener> listeners,
            Collection<String> subnets, Collection<String> securityGroups, boolean internal,
            Collection<AwsResourceTag> tags) {
        this.name = name;
        this.listeners = listeners;
        this.subnets = subnets;
        this.securityGroups = securityGroups;
        this.internal = internal;
        this.tags = tags;
    }

    public String getName() {
        return name;
    }

    public Collection<AwsLoadBalancerListener> getListeners() {
        return listeners;
    }

    public Collection<String> getSubnets() {
        return subnets;
    }

    public Collection<String> getSecurityGroups() {
        return securityGroups;
    }

    public boolean isInternal() {
        return internal;
    }

    public Collection<AwsResourceTag> getTags() {
        return tags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LoadBalancerParameters that = (LoadBalancerParameters) o;
        return internal == that.internal &&
                Objects.equals(name, that.name) &&
                Objects.equals(listeners, that.listeners) &&
                Objects.equals(subnets, that.subnets) &&
                Objects.equals(securityGroups, that.securityGroups) &&
                Objects.equals(tags, that.tags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, listeners, subnets, securityGroups, internal, tags);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {

        private String name;
        private Collection<AwsLoadBalancerListener> listeners = new ArrayList<>();
        private Collection<String> subnets = new ArrayList<>();
        private Collection<String> securityGroups = new ArrayList<>();
        private boolean internal;
        private Collection<AwsResourceTag> tags = new ArrayList<>();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withListeners(Collection<AwsLoadBalancerListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder withSubnets(Collection<String> subnets) {
            this.subnets = subnets;
            return this;
        }

        public Builder withSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder withInternal(boolean internal) {
            this.internal = internal;
            return this;
        }

        public Builder withTags(Collection<AwsResourceTag> tags) {
            this.tags = tags;
            return this;
        }

        public LoadBalancerParameters build() {
            return new LoadBalancerParameters(name, listeners, subnets, securityGroups, internal, tags);
        }
    }
}
