package pl.codewise.commons.aws.cqrs.model.ec2;

import com.google.common.base.MoreObjects;

import java.util.Objects;

public class AwsLoadBalancerListener {

    public final String protocol;
    public final int loadBalancerPort;
    public final int instancePort;
    public final String sslCertificateArn;

    public AwsLoadBalancerListener(String protocol, int loadBalancerPort, int instancePort, String sslCertificateArn) {
        this.protocol = protocol;
        this.loadBalancerPort = loadBalancerPort;
        this.instancePort = instancePort;
        this.sslCertificateArn = sslCertificateArn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsLoadBalancerListener that = (AwsLoadBalancerListener) o;
        return loadBalancerPort == that.loadBalancerPort &&
                instancePort == that.instancePort &&
                Objects.equals(protocol, that.protocol) &&
                Objects.equals(sslCertificateArn, that.sslCertificateArn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(protocol, loadBalancerPort, instancePort, sslCertificateArn);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("protocol", protocol)
                .add("loadBalancerPort", loadBalancerPort)
                .add("instancePort", instancePort)
                .add("sslCertificateArn", sslCertificateArn)
                .toString();
    }
}
