package pl.codewise.commons.aws.cqrs.model.ec2;

import com.google.common.base.Objects;

import java.util.Date;

public class AwsInstanceEbs {

    private final Date attachTime;
    private final boolean deleteOnTermination;
    private final String status;
    private final String volumeId;

    private AwsInstanceEbs(Date attachTime, boolean deleteOnTermination, String status, String volumeId) {
        this.attachTime = attachTime;
        this.deleteOnTermination = deleteOnTermination;
        this.status = status;
        this.volumeId = volumeId;
    }

    public Date getAttachTime() {
        return attachTime;
    }

    public boolean isDeleteOnTermination() {
        return deleteOnTermination;
    }

    public String getStatus() {
        return status;
    }

    public String getVolumeId() {
        return volumeId;
    }

    public Date attachTime() {
        return attachTime;
    }

    public boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    public String status() {
        return status;
    }

    public String volumeId() {
        return volumeId;
    }

    public static AwsInstanceEbs create(Date attachTime, boolean deleteOnTermination, String status, String volumeId) {
        return new AwsInstanceEbs(attachTime, deleteOnTermination, status, volumeId);
    }

    @Override
    public String toString() {
        return "AwsInstanceEbs{"
                + "attachTime=" + attachTime + ", "
                + "deleteOnTermination=" + deleteOnTermination + ", "
                + "status=" + status + ", "
                + "volumeId=" + volumeId
                + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsInstanceEbs that = (AwsInstanceEbs) o;
        return deleteOnTermination == that.deleteOnTermination &&
                Objects.equal(attachTime, that.attachTime) &&
                Objects.equal(status, that.status) &&
                Objects.equal(volumeId, that.volumeId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(attachTime, deleteOnTermination, status, volumeId);
    }
}
