package pl.codewise.commons.aws.cqrs.model.ec2;

import java.util.Objects;

public class AwsEbs {

    private final String snapshotId;
    private final Integer volumeSize;
    private final String volumeType;
    private final Boolean deleteOnTermination;
    private final Integer iops;
    private final Boolean encrypted;

    public AwsEbs(String snapshotId, Integer volumeSize, String volumeType, Boolean deleteOnTermination, Integer iops,
            Boolean encrypted) {
        this.snapshotId = snapshotId;
        this.volumeSize = volumeSize;
        this.volumeType = volumeType;
        this.deleteOnTermination = deleteOnTermination;
        this.iops = iops;
        this.encrypted = encrypted;
    }

    public String getSnapshotId() {
        return snapshotId;
    }

    public Integer getVolumeSize() {
        return volumeSize;
    }

    public String getVolumeType() {
        return volumeType;
    }

    public Boolean getDeleteOnTermination() {
        return deleteOnTermination;
    }

    public Integer getIops() {
        return iops;
    }

    public Boolean getEncrypted() {
        return encrypted;
    }

    @Override
    public String toString() {
        return "AwsEbs{" +
                "snapshotId='" + snapshotId + '\'' +
                ", volumeSize=" + volumeSize +
                ", volumeType='" + volumeType + '\'' +
                ", deleteOnTermination=" + deleteOnTermination +
                ", iops=" + iops +
                ", encrypted=" + encrypted +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AwsEbs awsEbs = (AwsEbs) o;
        return Objects.equals(snapshotId, awsEbs.snapshotId) &&
                Objects.equals(volumeSize, awsEbs.volumeSize) &&
                Objects.equals(volumeType, awsEbs.volumeType) &&
                Objects.equals(deleteOnTermination, awsEbs.deleteOnTermination) &&
                Objects.equals(iops, awsEbs.iops) &&
                Objects.equals(encrypted, awsEbs.encrypted);
    }

    @Override
    public int hashCode() {
        return Objects.hash(snapshotId, volumeSize, volumeType, deleteOnTermination, iops, encrypted);
    }
}
