package pl.codewise.commons.aws.cqrs.model.ec2;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

public class Ami {

    private final String imageId;
    private final String name;
    private final ZonedDateTime creationDate;
    private final String rootDeviceType;
    private final List<AwsResourceTag> tags;

    public Ami(String imageId, String name, ZonedDateTime creationDate, String rootDeviceType,
            List<AwsResourceTag> tags) {
        this.imageId = imageId;
        this.name = name;
        this.creationDate = creationDate;
        this.rootDeviceType = rootDeviceType;
        this.tags = tags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Ami ami = (Ami) o;
        return Objects.equals(imageId, ami.imageId) &&
                Objects.equals(name, ami.name) &&
                Objects.equals(creationDate, ami.creationDate) &&
                Objects.equals(rootDeviceType, ami.rootDeviceType) &&
                Objects.equals(tags, ami.tags);
    }

    @Override
    public int hashCode() {
        return Objects.hash(imageId, name, creationDate, rootDeviceType, tags);
    }

    @Override
    public String toString() {
        return "Ami{" +
                "imageId='" + imageId + '\'' +
                ", name='" + name + '\'' +
                ", creationDate=" + creationDate +
                ", rootDeviceType='" + rootDeviceType + '\'' +
                ", tags=" + tags +
                '}';
    }

    public String getImageId() {
        return imageId;
    }

    public String getName() {
        return name;
    }

    public ZonedDateTime getCreationDate() {
        return creationDate;
    }

    public String getRootDeviceType() {
        return rootDeviceType;
    }

    public List<AwsResourceTag> getTags() {
        return tags;
    }
}
